% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_difficulty.R
\name{item_difficulty}
\alias{item_difficulty}
\title{Difficulty of Questionnaire Items}
\usage{
item_difficulty(x)
}
\arguments{
\item{x}{Depending on the function, \code{x} may be a \code{matrix} as
returned by the \code{cor()}-function, or a data frame
with items (e.g. from a test or questionnaire).}
}
\value{
A data frame with three columns: The name(s) of the item(s), the item
     difficulties for each item, and the ideal item difficulty.
}
\description{
Compute various measures of internal consistencies
   for tests or item-scales of questionnaires.
}
\details{
This function calculates the item difficulty, which should
   range between 0.2 and 0.8. Lower values are a signal for
   more difficult items, while higher values close to one
   are a sign for easier items. The ideal value for item difficulty
   is \code{p + (1 - p) / 2}, where \code{p = 1 / max(x)}. In most
   cases, the ideal item difficulty lies between 0.5 and 0.8.
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_difficulty(x)
}
