% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_SNV_utility_functions.R
\name{fourGamete}
\alias{fourGamete}
\title{Four-Gamete Test}
\usage{
fourGamete(snv1, snv2)
}
\arguments{
\item{snv1}{First SNV.}

\item{snv2}{Second SNV.}
}
\value{
TRUE, if both SNVs are incompatible.
}
\description{
This function performs the Four-Gamete Test to check the compatability of two SNVs. If all four haplotypes
(00,10,01,11) are observed for two SNVs, those two SNVs are incompatible.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# Check the compatability of two SNVs.

fourGamete(snv1 = ex_hapMatSmall_data$hapmat[, 1], 
           snv2 = ex_hapMatSmall_data$hapmat[, 2])
}

}
\keyword{internal}
