% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional-options.R
\name{pense_options}
\alias{pense_options}
\title{Additional Options for the Penalized EN S-estimator}
\usage{
pense_options(delta = 0.25, maxit = 1000, eps = 1e-06,
  mscale_eps = 1e-08, mscale_maxit = 200, verbosity = 0, cc,
  en_correction = TRUE)
}
\arguments{
\item{delta}{desired breakdown point of the resulting estimator.}

\item{maxit}{maximum number of iterations allowed.}

\item{eps}{numeric tolerance for convergence.}

\item{mscale_eps, mscale_maxit}{maximum number of iterations and numeric
tolerance for the M-scale.}

\item{verbosity}{verbosity of the algorithm.}

\item{cc}{tuning constant for the S-estimator. Default is to chosen based
on the breakdown point \code{delta}. Should never have to be changed.}

\item{en_correction}{should the corrected EN estimator be used to choose
the optimal lambda with CV.
If \code{TRUE}, as by default, the estimator is "bias corrected".}
}
\value{
a checked options list.
}
\description{
Additional Options for the Penalized EN S-estimator
}
\seealso{
Other specifying additional options: \code{\link{en_options_aug_lars}},
  \code{\link{initest_options}},
  \code{\link{mstep_options}}
}
\concept{specifying additional options}
