% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penhdfeppml_cluster_int.R
\name{penhdfeppml_cluster_int}
\alias{penhdfeppml_cluster_int}
\title{Plugin Lasso Estimation}
\usage{
penhdfeppml_cluster_int(
  y,
  x,
  fes,
  cluster,
  tol = 1e-08,
  hdfetol = 1e-04,
  glmnettol = 1e-12,
  penalty = "lasso",
  penweights = NULL,
  saveX = TRUE,
  mu = NULL,
  colcheck_x = TRUE,
  colcheck_x_fes = TRUE,
  K = 15,
  init_z = NULL,
  post = FALSE,
  verbose = FALSE,
  lambda = NULL,
  phipost = TRUE,
  gamma_val = NULL
)
}
\arguments{
\item{y}{Dependent variable (a vector)}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{cluster}{Optional: a vector classifying observations into clusters (to use when calculating SEs).}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{hdfetol}{Tolerance parameter for the within-transformation step,
passed on to \code{collapse::fhdwithin}.}

\item{glmnettol}{Tolerance parameter to be passed on to \code{glmnet}.}

\item{penalty}{Only "lasso" is supported at the present stage.}

\item{penweights}{Optional: a vector of coefficient-specific penalties to use in plugin lasso when
\code{method == "plugin"}.}

\item{saveX}{Logical. If \code{TRUE}, it returns the values of x and z after partialling out the
fixed effects.}

\item{mu}{A vector of initial values for mu that can be passed to the command.}

\item{colcheck_x}{Logical. If \code{TRUE}, this checks collinearity between the independent variables and drops the
collinear variables.}

\item{colcheck_x_fes}{Logical. If \code{TRUE}, this checks whether the independent variables are perfectly explained
by the fixed effects drops those that are perfectly explained.}

\item{K}{Maximum number of iterations.}

\item{init_z}{Optional: initial values of the transformed dependent variable, to be used in the
first iteration of the algorithm.}

\item{post}{Logical. If \code{TRUE}, estimates a post-penalty regression with the selected variables.}

\item{verbose}{Logical. If \code{TRUE}, it prints information to the screen while evaluating.}

\item{lambda}{Penalty parameter (a number).}

\item{phipost}{Logical. If \code{TRUE}, the plugin coefficient-specific penalty weights are iteratively
calculated using estimates from a post-penalty regression. Otherwise, these are calculated using
estimates from a penalty regression.}

\item{gamma_val}{Numerical value that determines the regularization threshold as defined in Belloni, Chernozhukov, Hansen, and Kozbur (2016). NULL default sets parameter to 0.1/log(n).}
}
\value{
An object of class \code{elnet} with the elements described in \link[glmnet]{glmnet}, as
well as the following:
\itemize{
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{phi}: coefficient-specific penalty weights.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
}
\description{
Performs plugin lasso - PPML estimation with HDFE. This is an internal function, called by \code{mlfitppml_int} and
\code{penhdfeppml_int} when users select the \code{method = "plugin"} option, but it's made available
as a stand-alone option for advanced users who may prefer to avoid some overhead imposed by the
wrappers.
}
\details{
The plugin method uses coefficient-specific penalty weights that account for heteroskedasticity. The
penalty parameters are calculated automatically by the function using statistical theory - for a
brief discussion of this, see Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2021), and
for a more in-depth analysis, check Belloni, Chernozhukov, Hansen, and Kozbur (2016), which introduced
the specific implementation used in this package. Heuristically, the penalty parameters are set at
a level high enough so that the absolute value of the score for each regressor must be statistically
large relative to its standard error in order for the regressors to be selected.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
# To reduce run time, we keep only countries in Latin America and the Caribbean:
LatAmericaCar <- countries$iso[countries$sub.region == "Latin America and the Caribbean"]
trade <- trade[(trade$imp \%in\% LatAmericaCar) & (trade$exp \%in\% LatAmericaCar), ]
# Now generate the needed x, y and fes objects:
y <- trade$export
x <- data.matrix(trade[, -1:-6])
fes <- list(exp_time = interaction(trade$exp, trade$time),
            imp_time = interaction(trade$imp, trade$time),
            pair     = interaction(trade$exp, trade$imp))
# Finally, we try penhdfeppml_cluster_int:
reg <- penhdfeppml_cluster_int(y = y, x = x, fes = fes, cluster = fes$pair)

}
