% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_accessors.R
\name{relabel}
\alias{relabel}
\alias{labels.ped}
\alias{labels.list}
\title{Get or modify pedigree labels}
\usage{
relabel(x, new, old = labels(x))

\method{labels}{ped}(object, ...)

\method{labels}{list}(object, ...)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{new, old}{Character vectors (or coercible to character) of the same
length. ID labels in \code{old} are replaced by those in \code{new}.}

\item{object}{A \code{ped} object}

\item{...}{Not used}
}
\value{
\itemize{
\item \code{labels()} returns a character vector containing the ID labels of all
pedigree members. If the input is a list of ped objects, the output is a list
of character vectors.
\item \code{relabel()} returns \code{ped} object similar to the input except for the
labels.
}
}
\description{
Functions for getting or changing the ID labels of pedigree members.
}
\examples{

x = nuclearPed(1)
x
labels(x)

relabel(x, new = "girl", old = 3)

}
\seealso{
\code{\link[=ped]{ped()}}
}
\author{
Magnus Dehli Vigeland
}
