% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haldane.R
\name{haldane}
\alias{haldane}
\alias{kosambi}
\title{Genetic map functions}
\usage{
haldane(cM = NULL, rho = NULL)

kosambi(cM = NULL, rho = NULL)
}
\arguments{
\item{cM}{A numeric vector with genetic distances in centiMorgan, or NULL.}

\item{rho}{A numeric vector with recombination rates, or NULL.}
}
\value{
A numeric of the same length as the input.
}
\description{
Simple implementations of the classical map functions of Haldane and Kosambi,
relating the genetic distance and the recombination rate between two linked loci.
}
\examples{
cM = 0:200
dat = cbind(Haldane = haldane(cM = cM),
            Kosambi = kosambi(cM = cM))
matplot(cM, dat, ylab = "Recombination rate", type = "l")
legend("topleft", legend = colnames(dat), col = 1:2, lty = 1:2)


rho = seq(0, 0.49, length = 50)
dat2 = cbind(Haldane = haldane(rho = rho),
             Kosambi = kosambi(rho = rho))
matplot(rho, dat2, xlab = "Recombination rate", ylab = "cM", type = "l")
legend("topleft", legend = colnames(dat), col = 1:2, lty = 1:2)

}
