% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustRate.R
\name{adjustRate}
\alias{adjustRate}
\title{Adjust the overall mutation rate of a model}
\usage{
adjustRate(mutmat, newrate, afreq = NULL, rate = NULL)
}
\arguments{
\item{mutmat}{A mutation matrix with nonzero mutation overall rate.}

\item{newrate}{The new overall mutation rate.}

\item{afreq}{The allele frequencies. Extracted from the mutation matrix if
not provided.}

\item{rate}{The current overall mutation rate. Calculated from the input if
not provided.}
}
\value{
A new mutation matrix with the adjusted rate.
}
\description{
Adjusts the overall mutation rate of a model by scaling the off-diagonal
matrix entries.
}
\details{
The adjusted matrix is calculated as \code{a * M + (1-a) * I}, where \code{M} is the
original matrix, \code{a = newrate/rate}, and \code{I} is the identity matrix.

The maximum allowed value of \code{newrate} (to avoid negative values in the
adjusted matrix) is \verb{rate/(1 - m))}, where \code{m} is the smallest diagonal
element in the original matrix.
}
\examples{
m = mutationMatrix("equal", afreq = c(a=0.2, b=0.3, c=0.5), rate = 0.2)
m
adjustRate(m, 0.4)

}
\seealso{
\code{\link[=mutRate]{mutRate()}}
}
