% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParams.R
\name{getParams}
\alias{getParams}
\title{Get model parameters}
\usage{
getParams(mut, params = NULL, format = 1, sep = "/")
}
\arguments{
\item{mut}{A \code{\link[=mutationModel]{mutationModel()}} or \code{\link[=mutationMatrix]{mutationMatrix()}}.}

\item{params}{A vector contain some or all of the words "model", "rate",
"range", "rate2", "seed". If NULL (default), all present parameters are
included.}

\item{format}{A numeric code indicating the wanted output format. See Value.}

\item{sep}{A separator character used to paste male and female values.
Ignored unless \code{format = 3}.}
}
\value{
When \code{mut} is a \code{mutationModel} with different male/female
parameters, the output format is dictated by the \code{format} option, with the
following possibilities:
\enumerate{
\item A data frame with 2 rows labelled 'female' and 'male'.
\item A data frame with 1 row and female/male columns suffixed by .F/.M
respectively.
\item A data frame with 1 row, in which female/male values are pasted together
(separated with \code{sep}) if different.
}

If \code{mut} is a \code{mutationMatrix} the output always has 1 row.
}
\description{
Extract model parameters of a mutation matrix/model.
}
\examples{
M = mutationModel("equal", 1:2, rate = list(female = 0.2, male = 0.1))
getParams(M)
getParams(M, format = 2)
getParams(M, format = 3)
getParams(M, format = 3, sep = "|")

}
