% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{archigos}
\alias{archigos}
\title{Archigos: A (Subset of a) Dataset on Political Leaders}
\format{
A data frame with 3409 observations on the following 11 variables.
\describe{
\item{\code{gwcode}}{a numeric vector for the Gleditsch-Ward state code}
\item{\code{obsid}}{a character vector for observation ID}
\item{\code{leadid}}{the unique leader identifier}
\item{\code{leader}}{the leader name}
\item{\code{yrborn}}{the year the leader was born}
\item{\code{gender}}{a categorical variable for leader gender ("M" for men, "W" for women)}
\item{\code{startdate}}{a date for the leader start date}
\item{\code{enddate}}{a date for the leader end date}
\item{\code{entry}}{a character vector for the leader's entry type}
\item{\code{exit}}{a character vector for the leader's exit type}
\item{\code{exitcode}}{a character vector for more information about the leader's exit type}
}
}
\usage{
archigos
}
\description{
These are leader-level data drawn from the Archigos data. Space considerations mean I offer here just a few columns
based on these data.  Data are version 4.1.
}
\details{
Space considerations mean I can only offer a few columns from the
overall data. Archigos data are rich with information. Consult the raw data
available on Hein Goeman's website for more.

To best conform with data requirements on CRAN, a few leader names were
renamed if they included irregular characters (e.g. umlauts or accents).
These leaders, in these particular applications, hav been renamed to "(Juan
Orlando) Hernandez" (\code{HON-2014}), "(Antonio) Saca Gonzalez" (\code{SAL-2004}),
"Julian Trujillo Largacha" (\code{COL-1878}), "Cesar Gaviria Trujillo"
(\code{COL-1990}), "Gabriel Garcia Moreno" (\code{ECU-1869}), "Marcos A. Morinigo"
(\code{PAR-1894-1}), "Higinio Morinigo" (\code{PAR-1940}), "Sebastian Pinera"
(\code{CHL-2010}), "Sauli Niinisto" (\code{FIN-2012}), "Louis Gerhard De Geer"
(\code{SWD-1876}), "Stefan Lofven" (\code{SWD-2014}), "Lars Lokke Rasmussen"
(\code{DEN-2009}, \code{DEN-2015}), and "Fernando de Araujo" (\code{ETM-2008-1}). None of
these names contain these special characters in the data here.

For clarity's sake, I renamed the \code{ccode} column in the raw data to be
\code{gwcode}. This is because it may deceive the user peeking into the data
that these are not Correlates of War state codes, but Gleditsch-Ward
state codes.
}
\references{
Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing
Archigos: A Dataset of Political Leaders" \emph{Journal of Peace Research}
46(2): 269--83.
}
\keyword{datasets}
