% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_extdata.R
\name{download_extdata}
\alias{download_extdata}
\title{Download Some Extra Data for Peace Science Research}
\usage{
download_extdata(overwrite = FALSE)
}
\arguments{
\item{overwrite}{logical, defaults to FALSE. If FALSE, the function checks to see if you've already
downloaded the data and, if you already have, it does nothing. If TRUE, the function redownloads the data.}
}
\value{
\code{download_extdata()} downloads some extra data stored on my website (\url{http://svmiller.com}) and
sticks them in the \code{extdata} directory in the package. Right now, these data are just the directed dyad-year
Correlates of War trade data.
}
\description{
\code{download_extdata()} leverages R's \code{inst} directory flexibility to allow you to download
some extra data and store it in the package.
}
\section{A Description of Various Data Sets This Will Download}{
Running \code{download_extdata()} returns the following data that will be stored in the package's \code{extdata} directory.
\subsection{Correlates of War Dyadic Trade Data Set (v. 4.0)}{

These are directed dyad-year-level data for national trade from the Correlates of War project.\tabular{ll}{
   COLUMN \tab DESCRIPTION \cr
   \code{ccode1} \tab a numeric vector for the Correlates of War state code for the first state \cr
   \code{ccode2} \tab a numeric vector for the Correlates of War state code for the second state \cr
   \code{year} \tab the year \cr
   \code{flow1} \tab imports of \code{ccode1} from \code{ccode2}, in current million USD \cr
   \code{flow2} \tab imports of \code{ccode2} from \code{ccode1}, in current million USD \cr
   \code{smoothflow1} \tab smoothed \code{flow1} values \cr
   \code{smoothflow2} \tab smoothed \code{flow2} values \cr
}

}
}

\examples{

\dontrun{
download_extdata()
}
}
\references{
Barbieri, Katherine, Omar M. G. Keshk, and Brian Pollins. 2009. "TRADING DATA: Evaluating our Assumptions and Coding Rules."
\emph{Conflict Management and Peace Science}. 26(5): 471-491.
}
\author{
Steven V. Miller
}
