% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_exploratory.R
\name{data.info}
\alias{data.info}
\title{Show Basic Structure of Panel Dataset.}
\usage{
data.info(object, i.name = NULL, t.name = NULL, ...)
}
\arguments{
\item{object}{An object of class `data.frame`.}

\item{i.name}{Column name of cross-section identifier.}

\item{t.name}{Column name of time-series identifier.}

\item{...}{further arguments.}
}
\value{
Returns information if panel dataset contained
   in an object of class `data.frame` is a balanced or
   unbalanced panel dataset.
}
\description{
\code{data.info} shows basic structure of a balanced/unbalanced
   panel dataset contained in a `data.frame`.
}
\examples{
## Load data
data(ABdata, package = "pdynmc")
dat <- ABdata
dat[,c(4:7)] <- log(dat[,c(4:7)])
dat <- dat[c(1:140), ]

## Code example
data.info(dat, i.name = "firm", t.name = "year")

data.info(dat[dat$year \%in\% 1979:1981, ], i.name = "firm", t.name = "year")


}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
\author{
Markus Fritsch, Joachim Schnurbus
}
