% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_moment.R
\name{summ_moment}
\alias{summ_moment}
\alias{summ_skewness}
\alias{summ_kurtosis}
\title{Summarize distribution with moment}
\usage{
summ_moment(f, order, central = FALSE, standard = FALSE, absolute = FALSE)

summ_skewness(f)

summ_kurtosis(f, excess = TRUE)
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{order}{A single number representing order of a moment. Should be
non-negative number (even fractional).}

\item{central}{Whether to compute central moment (subtract
\link[=summ_mean]{mean} of distribution).}

\item{standard}{Whether to compute standard moment (divide by \link[=summ_sd]{standard deviation} of distribution).}

\item{absolute}{Whether to compute absolute moment (take absolute value of
random variable created after possible effect of \code{central} and \code{standard}).}

\item{excess}{Whether to compute excess kurtosis (subtract 3 from third order
central standard moment). Default is \code{TRUE}.}
}
\value{
A single number representing moment. If \code{summ_sd(f)} is zero and
\code{standard} is \code{TRUE}, then it is \code{Inf}; otherwise - finite number.
}
\description{
\code{summ_moment()} computes a moment of distribution. It can be one of eight
kinds determined by the combination of \code{central}, \code{standard}, and \code{absolute}
boolean features. \code{summ_skewness()} and \code{summ_kurtosis()} are wrappers for
commonly used kinds of moments: third and forth order central standard ones.
\strong{Note} that \code{summ_kurtosis()} by default computes excess kurtosis, i.e.
subtracts 3 from computed forth order moment.
}
\examples{
d_beta <- as_d(dbeta, shape1 = 2, shape2 = 1)

# The same as `summ_mean(d_beta)`
summ_moment(d_beta, order = 1)

# The same as `summ_var(d_beta)`
summ_moment(d_beta, order = 2, central = TRUE)

# Return the same number
summ_moment(d_beta, order = 3, central = TRUE, standard = TRUE)
summ_skewness(d_beta)

# Return the same number representing non-excess kurtosis
summ_moment(d_beta, order = 4, central = TRUE, standard = TRUE)
summ_kurtosis(d_beta, excess = FALSE)
}
\seealso{
\code{\link[=summ_center]{summ_center()}} for computing distribution's center, \code{\link[=summ_spread]{summ_spread()}}
for spread.

Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_pval}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
