% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{exemplar}
\alias{exemplar}
\alias{exemplar.data.frame}
\alias{exemplar.matrix}
\alias{exemplar.dgCMatrix}
\title{Exemplar observation}
\usage{
exemplar(object)

\method{exemplar}{data.frame}(object)

\method{exemplar}{matrix}(object)

\method{exemplar}{dgCMatrix}(object)
}
\arguments{
\item{object}{A data frame, matrix, or
\code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} (the latter two are
supported by \code{\link[xgboost]{xgboost}}).}
}
\value{
A data frame with the same number of columns as \code{object} and a
single row.
}
\description{
Construct a single "exemplar" record from a data frame. For now, all numeric
columns (including \code{"\link{Date}"} objects) are replaced with their
corresponding median value and non-numeric columns are replaced with their
most frequent value.
}
\examples{
set.seed(1554)  # for reproducibility
train <- data.frame(
  x = rnorm(100),
  y = sample(letters[1L:3L], size = 100, replace = TRUE,
             prob = c(0.1, 0.1, 0.8))
)
exemplar(train)
}
