% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimatePcev.R
\name{estimatePcev}
\alias{estimatePcev}
\alias{estimatePcev.PcevBlock}
\alias{estimatePcev.PcevClassical}
\alias{estimatePcev.default}
\title{Estimation of PCEV}
\usage{
estimatePcev(pcevObj, ...)

\method{estimatePcev}{default}(pcevObj, ...)

\method{estimatePcev}{PcevClassical}(pcevObj, shrink, index, ...)

\method{estimatePcev}{PcevBlock}(pcevObj, shrink, index, ...)
}
\arguments{
\item{pcevObj}{A pcev object of class \code{PcevClassical} or
\code{PcevBlock}}

\item{...}{Extra parameters.}

\item{shrink}{Should we use a shrinkage estimate of the residual variance?}

\item{index}{If \code{pcevObj} is of class \code{PcevBlock}, index is a vector
describing the block to which individual response variables correspond.}
}
\value{
A list containing the variance components, the first PCEV, the
  eigenvalues of \eqn{V_R^{-1}V_G} and the estimate of the shrinkage
  parameter \eqn{\rho}
}
\description{
\code{estimatePcev} estimates the PCEV.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{PcevClassical}: 

\item \code{PcevBlock}: 
}}
\seealso{
\code{\link{computePCEV}}
}

