% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{Idom.setPEstd.tri}
\alias{Idom.setPEstd.tri}
\title{The indicator for the set of points \code{S} being a dominating set
or not for Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
standard equilateral triangle case}
\usage{
Idom.setPEstd.tri(S, Xp, r, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points
whose PE proximity regions are considered.}

\item{Xp}{A set of 2D points
which constitutes the vertices of the PE-PCD.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region in the
standard equilateral triangle
\eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))};
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
\eqn{I(}\code{S} a dominating set of PE-PCD\eqn{)} for \code{S}
in the standard equilateral triangle,
that is, returns 1 if \code{S} is a dominating set of PE-PCD,
and returns 0 otherwise,
where PE proximity region is constructed in the standard equilateral triangle \eqn{T_e}.
}
\description{
Returns \eqn{I(}\code{S} a dominating set of PE-PCD
whose vertices are the data points \code{Xp}\eqn{)}
for \code{S} in the standard equilateral triangle,
that is,
returns 1 if \code{S} is a dominating set of PE-PCD,
and returns 0 otherwise.

PE proximity region is constructed
with respect to the standard equilateral triangle
\eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with
expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_e}
(which is also equivalent to the circumcenter of \eqn{T_e}).
Vertices of \eqn{T_e} are also labeled as 1, 2, and 3,
respectively.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

r<-1.5

S<-rbind(Xp[1,],Xp[2,])
Idom.setPEstd.tri(S,Xp,r,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,],c(.2,.5))
Idom.setPEstd.tri(S,Xp[3,],r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.setPEtri}} and \code{\link{Idom.setCSstd.tri}}
}
\author{
Elvan Ceyhan
}
