% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{radius}
\alias{radius}
\title{The radius of a point from one class with respect to points from the other class}
\usage{
radius(p, Y)
}
\arguments{
\item{p}{A \eqn{d}-dimensional point for which radius is computed. Radius of \code{p} equals to the
distance to the closest \code{Y} point to \code{p}.}

\item{Y}{A set of \eqn{d}-dimensional points representing the reference points for the balls. That is, radius
of the point \code{p} is defined as the minimum distance to the \code{Y} points.}
}
\value{
A \code{list} with three elements
\item{rad}{Radius value for the point, \code{p} defined as \eqn{\min_{y in Y} d(p,y)}}
\item{index.of.clYpnt}{Index of the closest \code{Y} points to the point \code{p}}
\item{closest.Ypnt}{The closest \code{Y} point to the point \code{p}}
}
\description{
Returns the radius for the ball centered at point \code{p} with radius=min distance to \code{Y} points.
That is, for the point \code{p} \eqn{radius= \min_{y \in Y}d(p,y)} (i.e., distance from \code{p} to the closest \code{Y} point).
The point \code{p} and \code{Y} points must be of same dimension.
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

ny<-10
Y<-cbind(runif(ny),runif(ny))
radius(A,Y)

nx<-10
X<-cbind(runif(nx),runif(nx))
rad<-rep(0,nx)
for (i in 1:nx)
rad[i]<-radius(X[i,],Y)$rad

Xlim<-range(X[,1]-rad,X[,1]+rad,Y[,1])
Ylim<-range(X[,2]-rad,X[,2]+rad,Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(rbind(Y),asp=1,pch=16,col=2,xlab="",ylab="",
main="Circles Centered at Class X Points with \n Radius Equal to the Distance to Closest Y Point",
axes=TRUE, xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(rbind(X))
interp::circles(X[,1],X[,2],rad,lty=1,lwd=1,col=4)

#For 1D data
ny<-5
Y<-runif(ny)
Ym = as.matrix(Y)
radius(1,Ym)  #this works as Y is treated as 1D data sets
#but will give error if radius(1,Y) is used
#as Y is treated as a vector (i.e., points)

#For 3D data
ny<-5
X<-runif(3)
Y<-cbind(runif(ny),runif(ny),runif(ny))
radius(X,Y)
}

}
\seealso{
\code{\link{radii}}
}
\author{
Elvan Ceyhan
}
