% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{plotDeltri}
\alias{plotDeltri}
\title{The scatterplot of points from one class and plot of the Delaunay triangulation of the other class}
\usage{
plotDeltri(
  Xp,
  Yp,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points whose scatterplot is to be plotted.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges (default=\code{NULL} for both)}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A scatterplot of \code{Xp} points and the Delaunay triangulation of \code{Yp} points.
}
\description{
Plots the scatter plot of \code{Xp} points together with the Delaunay triangles based on the \code{Yp} points.
Both sets of points are of 2D.

See (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

plotDeltri(Xp,Yp,xlab="",ylab="",main="X points and Delaunay Triangulation of Y points")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[interp]{plot.triSht}} in \code{interp} package
}
\author{
Elvan Ceyhan
}
