% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{num.del.tri}
\alias{num.del.tri}
\title{Number of Delaunay triangles based on a 2D data set}
\usage{
num.del.tri(Yp)
}
\arguments{
\item{Yp}{A set of 2D points which constitute the vertices of Delaunay triangles.}
}
\value{
Number of Delaunay triangles based on \code{Yp} points.
}
\description{
Returns the number of Delaunay triangles based on the 2D set of points \code{Yp}.
See (\insertCite{okabe:2000,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and
the corresponding algorithm.
}
\examples{
ny<-10

set.seed(1)
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

num.del.tri(Yp)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotDeltri}}
}
\author{
Elvan Ceyhan
}
