% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{cent.nondegPE}
\alias{cent.nondegPE}
\title{Centers for non-degenerate asymptotic distribution of domination number of
Proportional Edge Proximity Catch Digraphs (PE-PCDs)}
\usage{
cent.nondegPE(tri, r)
}
\arguments{
\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} for this function.}
}
\value{
The centers (stacked row-wise) which give nondegenerate asymptotic distribution
for the domination number of PE-PCD for uniform data in a triangle, \code{tri}.
}
\description{
Returns the centers which yield nondegenerate asymptotic distribution for the domination number
of PE-PCD for uniform data in a triangle, \code{tri}\eqn{=T(v_1,v_2,v_3)}.

PE proximity region is defined with
respect to the triangle \code{tri} with expansion parameter \code{r} in \eqn{(1,1.5]}.

Vertex regions are defined with the centers that are output of this function.
Centers are stacked row-wise with row number is corresponding to the vertex
row number in \code{tri} (see the examples for an illustration). The center labels 1,2,3 correspond
to the vertices \eqn{M_1}, \eqn{M_2}, and \eqn{M_3} (which are the three centers for \code{r} in \eqn{(1,1.5)} which becomes center of mass
for \eqn{r=1.5}.).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
r<-1.35

Ms<-cent.nondegPE(Tr,r)
Ms

Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",main="Centers of nondegeneracy\n for the PE-PCD in a triangle",
axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Ms,pch=".",col=1)
polygon(Ms,lty=2)

xc<-Tr[,1]+c(-.02,.02,.02)
yc<-Tr[,2]+c(.02,.02,.03)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

xc<-Ms[,1]+c(-.04,.04,.03)
yc<-Ms[,2]+c(.02,.02,.05)
txt.str<-c("M1","M2","M3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\author{
Elvan Ceyhan
}
