% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{NumArcsCSint}
\alias{NumArcsCSint}
\title{Number of arcs of  Central Similarity Proximity Catch Digraphs (CS-PCDs) - one interval case}
\usage{
NumArcsCSint(Xp, int, t, c = 0.5)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of CS-PCD.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Total number of arcs in all intervals (including the end intervals),
i.e., the number of arcs for the entire CS-PCD}
\item{num.in.range}{Number of \code{Xp} points in the interval \code{int}}
\item{num.in.ints}{The vector of number of \code{Xp} points in the partition intervals (including the end intervals)}
\item{int.num.arcs}{The \code{vector} of the number of arcs of the component of the CS-PCD in the
partition intervals (including the end intervals)}
\item{data.int.ind}{A \code{vector} of indices of partition intervals in which data points reside.
Partition intervals are numbered from left to right with 1 being the left end interval.}
}
\description{
Returns the number of arcs and various other quantities, vectors, and lists for Central Similarity Proximity Catch Digraph
(CS-PCD) whose vertices are the data points in \code{Xp} in the one middle interval case.

The data points could be inside or outside the interval is \code{int}\eqn{=(a,b)}.

CS proximity region is constructed
with an expansion parameter \eqn{t>0} and a centrality parameter \eqn{c \in (0,1)}.
CS proximity region is constructed for both points inside and outside the interval, hence
the arcs may exist for all points inside or outside the interval.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
\dontrun{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

n<-10
set.seed(1)
Xp<-runif(n,a,b)
NumArcsCSint(Xp,int,t,c)
NumArcsCSint(Xp,int,t,c=.3)
NumArcsCSint(Xp,int,t=1.5,c)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSmid.int}}, \code{\link{NumArcsCSend.int}}, and \code{\link{NumArcsPEint}}
}
\author{
Elvan Ceyhan
}
