% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{re.bastriCM}
\alias{re.bastriCM}
\title{The index of the \eqn{CM}-edge region in a basic triangle that contains a point}
\usage{
re.bastriCM(pt, c1, c2)
}
\arguments{
\item{pt}{A 2D point for which \eqn{CM}-edge region it resides in is to be determined in the
basic triangle \eqn{T_b}.}

\item{c1, c2}{Positive real numbers which constitute the upper vertex of the basic triangle (i.e., the vertex
adjacent to the shorter edges of \eqn{T_b}); \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and
\eqn{(1-c_1)^2+c_2^2 \le 1}.}
}
\value{
A \code{list} with three elements

\item{re}{Index of the \eqn{CM}-edge region that contains point, \code{pt} in the basic triangle \eqn{T_b}}
\item{tri}{The vertices of the triangle, where row labels are \eqn{A=(0,0)}, \eqn{B=(1,0)}, and \eqn{C=(c_1,c_2)}
with edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge whose region contains point, \code{pt}, in the
basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2)} where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1} with
edge regions based on center of mass \eqn{CM=(A+B+C)/3}.

Edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
If the point, \code{pt}, is not inside \code{tri}, then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,CM)}, edge region 2 is \eqn{T(A,C,CM)}, and edge region 3 is \eqn{T(A,B,CM)}.

Any given triangle can be mapped to the basic triangle
by a combination of rigid body motions (i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle. Hence basic triangle is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6
P<-c(.4,.2)
re.bastriCM(P,c1,c2)

c1<-.5; c2<-.8
P<-c(.4,.2)
re.bastriCM(P,c1,c2)

P<-c(.8,.2)
re.bastriCM(P,c1,c2)

P<-c(1.8,.2)
re.bastriCM(P,c1,c2)

c1<-.4; c2<-.6
A<-c(0,0);B<-c(1,0);C<-c(c1,c2);
Tb<-rbind(A,B,C)
CM<-(A+B+C)/3

re.bastriCM(A,c1,c2)
re.bastriCM(B,c1,c2)
re.bastriCM(C,c1,c2)
re.bastriCM(CM,c1,c2)

n<-10  #try also n<-20
dat<-runif.bastri(n,c1,c2)$g

re<-vector()
for (i in 1:n)
  re<-c(re,re.bastriCM(dat[i,],c1,c2)$re)
re

Xlim<-range(Tb[,1],dat[,1])
Ylim<-range(Tb[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(dat,pch=".")
polygon(Tb)
L<-Tb; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(dat,labels=factor(re))

txt<-rbind(Tb,CM)
xc<-txt[,1]+c(-.03,.03,.02,0)
yc<-txt[,2]+c(.02,.02,.02,-.04)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.triCM}}, \code{\link{re.tri.cent}},
\code{\link{re.bastri.cent}}, \code{\link{reTeCM}}, and \code{\link{redge.triCM}}
}
\author{
Elvan Ceyhan
}
