% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotCSregsMT}
\alias{plotCSregsMT}
\title{The plot of the Central Similarity (CS) Proximity Regions for a 2D data set - multiple triangle case}
\usage{
plotCSregsMT(
  Xp,
  Yp,
  t,
  M = c(1, 1, 1),
  asp = NA,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points for which CS proximity regions are constructed.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.}

\item{asp}{A numeric value, giving the aspect ratio y/x (default is \code{NA}), see the official help for \code{asp} by
typing "? asp".}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the \code{Xp} points, Delaunay triangles based on \code{Yp} and also the CS proximity regions
for \code{Xp} points inside the convex hull of \code{Yp} points
}
\description{
Plots the points in and outside of the Delaunay triangles based on \code{Yp} points which partition
the convex hull of \code{Yp} points and also plots the CS proximity regions
for \code{Xp} points and the Delaunay triangles based on \code{Yp} points.

CS proximity regions are contructed with respect to the Delaunay triangles with the expansion parameter \eqn{t>0}.

Edge regions in each triangle is based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of each Delaunay triangle
(default for \eqn{M=(1,1,1)} which is the center of mass of the triangle).

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}) more on the CS proximity regions.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

t<-1.5  #try also t<-2

Xlim<-range(Xp[,1],Yp[,1])
Ylim<-range(Xp[,2],Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotCSregsMT(Xp,Yp,t,M,xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))

plotCSregsMT(Xp,Yp[1:3,],t,M,xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSregsTri}}, \code{\link{plotASregsMT}} and \code{\link{plotPEregsMT}}
}
