% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Plane}
\alias{Plane}
\title{The plane passing through three distinct 3D points \code{a}, \code{b}, and \code{c}}
\usage{
Plane(a, b, c, x, y)
}
\arguments{
\item{a, b, c}{3D points that determine the plane (i.e., through which the plane is passing).}

\item{x, y}{Scalars or vectors of scalars representing the x- and y-coordinates of the plane.}
}
\value{
A list with the elements
\item{desc}{A description of the plane}
\item{points}{The input points \code{a}, \code{b}, and \code{c} through which the plane is passing
(stacked row-wise, i.e., row 1 is point \code{a}, row 2 is point \code{b} and row 3 is point \code{c}).}
\item{x,y}{The input vectors which constitutes the x- and y-coordinates of the point(s) of interest on the
plane. \code{x} and \code{y} can be scalars or vectors of scalars.}
\item{z}{The output vector which constitutes the z-coordinates of the point(s) of interest on the plane.
If \code{x} and \code{y} are scalars, \code{z} will be a scalar and
if \code{x} and \code{y} are vectors of scalars, then \code{z} needs to be matrix of scalars,
containing the z-coordinate for each pair of \code{x} and \code{y} values.}
\item{coeff}{Coefficients of the plane (in the \eqn{z = A x+B y+C} form).}
\item{equation}{Equation of the plane in long form}
\item{equation2}{Equation of the plane in short form, to be inserted on the plot}
}
\description{
An object of class "Planes".
Returns the equation and z-coordinates of the plane passing through three distinct 3D points \code{a}, \code{b}, and \code{c}
with x- and y-coordinates are provided in vectors \code{x} and \code{y}, respectively.
}
\examples{
\donttest{
A<-c(1,10,3); B<-c(1,1,3); C<-c(3,9,12)

pts<-rbind(A,B,C)
Plane(A,B,C,.1,.2)

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1 #how far to go at the lower and upper ends in the y-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=20)  #try also l=100
y<-seq(yr[1]-yf,yr[2]+yf,l=20)  #try also l=100

plABC<-Plane(A,B,C,x,y)
plABC
summary(plABC)
plot(plABC)

Plane(A,B,A+B,.1,.2)

z.grid<-plABC$z

persp(x,y,z.grid, xlab="x",ylab="y",zlab="z",
theta = -30, phi = 30, expand = 0.5, col = "lightblue",
      ltheta = 120, shade = 0.05, ticktype = "detailed")

zr<-max(z.grid)-min(z.grid)
Pts<-rbind(A,B,C)+rbind(c(0,0,zr*.1),c(0,0,zr*.1),c(0,0,zr*.1))
Mn.pts<-apply(Pts,2,mean)

plot3D::persp3D(z = z.grid, x = x, y = y, theta =225, phi = 30, ticktype = "detailed")
#plane spanned by points A, B, C
#add the defining points
plot3D::points3D(Pts[,1],Pts[,2],Pts[,3], add=TRUE)
plot3D::text3D(Pts[,1],Pts[,2],Pts[,3], c("A","B","C"),add=TRUE)
plot3D::text3D(Mn.pts[1],Mn.pts[2],Mn.pts[3],plABC$equation,add=TRUE)
plot3D::polygon3D(Pts[,1],Pts[,2],Pts[,3], add=TRUE)

Plane(A,B,C,.1,.2)
}

}
\seealso{
\code{\link{paraplane}}
}
