% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsCStri}
\alias{NumArcsCStri}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) - one triangle case}
\usage{
NumArcsCStri(Dt, tri, t, M = c(1, 1, 1))
}
\arguments{
\item{Dt}{A set of 2D points which constitute the vertices of CS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \code{tri}.}
}
\value{
Number of arcs for the CS-PCD with vertices being 2D data set, \code{dat}, in \code{tri}
with expansion parameter, \eqn{t>0}, and center of mass CM. CS proximity regions are defined only
for \code{Dt} points inside \code{tri}, i.e. arcs are possible for such points only.
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose vertices are the
given 2D numerical data set, \code{dat}.

CS proximity region NCS(x,r) is defined with respect to the triangle, \code{tri}  with expansion parameter \eqn{t>0}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \code{tri} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

NumArcsCStri(dat,Tr,t=.5,M)
NumArcsCStri(dat,Tr,t=1,M)
NumArcsCStri(dat,Tr,t=1.5,M)

NumArcsCStri(c(1.4,.2),Tr,t=.5,M)

t<-.5
NumArcsCStri(dat,Tr,t,M)

dat.fr<-data.frame(a=dat)
NumArcsCStri(dat.fr,Tr,t,M)

dat.fr<-data.frame(a=Tr)
NumArcsCStri(dat,dat.fr,t,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSTe}}, \code{\link{NumArcsCSMT}}, \code{\link{NumArcsPEtri}},
and \code{\link{NumArcsAStri}}
}
