% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NCSint}
\alias{NCSint}
\title{The end points of the Central Similarity (CS) Proximity Region for a point - one interval case}
\usage{
NCSint(x, t, c = 0.5, int)
}
\arguments{
\item{x}{A 1D point for which CS proximity region is constructed}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}, and default=.5}

\item{int}{A vector of two real numbers representing an interval}
}
\value{
The interval which constitutes the CS proximity region for the point \code{x}
}
\description{
Returns the end points of the interval which constitutess the CS proximity region for a point in the
interval \eqn{int=(a,b)=(rv=1,rv=2)}.

CS proximity region is constructed with respect to the interval \code{int}
with expansion parameter \eqn{t>0} and centrality parameter \code{c} in \eqn{(0,1)}.

Vertex regions are based on the (parameterized) center, \eqn{M_c},
which is \eqn{M_c=a+c(b-a)} for the interval, \eqn{int=(a,b)}.
The CS proximity region is constructed whether \code{x} is inside or outside the interval \code{int}.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

NCSint(7,t,c,int)
NCSint(17,t,c,int)
NCSint(1,t,c,int)
NCSint(-1,t,c,int)

NCSint(3,t,c,int)
NCSint(4,t,c,int)
NCSint(a,t,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NPEint}} and \code{\link{NCStri}}
}
