% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_pbox.R
\name{final_pbox}
\alias{final_pbox}
\alias{final_pbox,ANY-method}
\title{Build a Multivariate Distribution from Copula}
\usage{
final_pbox(results_df, allDitrs, data, verbose = TRUE)

\S4method{final_pbox}{ANY}(results_df, allDitrs, data, verbose = TRUE)
}
\arguments{
\item{results_df}{A data.table with AIC and parameter estimates of evaluated copulas and families from `fit_copula_pbox`.}

\item{allDitrs}{A list containing fitted distributions for each variable from `fit_dist_pbox`.}

\item{data}{A data frame or data table; this will be coerced to a `data.table` internally.}

\item{verbose}{control verbosity of the output. Default to TRUE.}
}
\value{
An object of class `mvdc` representing the combined multivariate distribution.
}
\description{
Combines the results from `fit_copula_pbox` and `fit_dist_pbox` to build a multivariate distribution from copula,
selecting the best copula based on AIC and utilizing the best-fitted marginal distributions. Note that

Method to construct a `mvdc` object by combining best-fit copula and marginal distribution results.
The method uses the best copula model as determined by the lowest AIC and combines it with
marginal distributions fitted to each variable.
}
\examples{
  data("SEAex")
  copulaFits <- fit_copula_pbox(data = SEAex, .copula_families)
  distFits <- fit_dist_pbox(data = SEAex)
  final_mvd <- final_pbox(copulaFits, distFits$allDitrs, SEAex)
  print(final_mvd)
}
