% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_apply.R
\docType{methods}
\name{ddmatrix-apply}
\alias{ddmatrix-apply}
\alias{apply}
\alias{apply,ddmatrix-method}
\title{Apply Family of Functions}
\usage{
\S4method{apply}{ddmatrix}(X, MARGIN, FUN, ..., reduce = FALSE,
  proc.dest = "all")
}
\arguments{
\item{X}{distributed matrix}

\item{MARGIN}{subscript over which the function will be applied}

\item{FUN}{the function to be applied}

\item{...}{additional arguments to FUN}

\item{reduce}{logical or string. See details}

\item{proc.dest}{Destination process (or 'all') if a reduction occurs}
}
\value{
Returns a distributed matrix unless a reduction is requested, then a
global matrix/vector is returned.
}
\description{
Apply a function to the margins of a distributed matrix.
}
\details{
If \code{reduce==TRUE} then a global matrix or vector (whichever is more
appropriate) will be returned. The argument \code{proc.dest=} behaves
exactly as in the \code{as.vector()} and \code{as.matrix()} functions of
\pkg{pbdDMAT}. If \code{reduce=FALSE} then a distributed matrix is returned.
Other acceptable arguments are \code{reduce="matrix"} and
\code{reduce="vector"} which demand global matrix or vector return,
respectively. This should generally be slightly more efficient than running
apply and then calling \code{as.vector()} or \code{as.matrix()}.
}
\keyword{Extraction}
\keyword{Methods}
