% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify}
\alias{verify}
\alias{verify.chol}
\alias{verify.inverse}
\alias{verify.solve}
\alias{verify.svd}
\title{Distributed Linear Algebra Verification}
\usage{
verify.svd(nrows = 1000, ncols = 1000, mean = 0, sd = 1, bldim = 8,
  tol = 1e-07, ICTXT = .pbd_env$ictxt)

verify.chol(nrows = 1000, mean = 0, sd = 1, bldim = 8, tol = 1e-07,
  ICTXT = .pbd_env$ictxt)

verify.inverse(nrows = 1000, mean = 0, sd = 1, bldim = 8, tol = 1e-07,
  ICTXT = .pbd_env$ictxt)

verify.solve(nrows = 1000, mean = 0, sd = 1, const = 1, bldim = 8,
  tol = 1e-07, ICTXT = .pbd_env$ictxt)
}
\arguments{
\item{nrows, ncols}{global dimension.}

\item{mean, sd}{mean and standard deviation when sampling from a normal
distribution.}

\item{bldim}{blocking dimension.}

\item{tol}{numeric tolerance for testing equality. Differences smaller than
\code{tol} are considered equal.}

\item{ICTXT}{BLACS context}

\item{const}{numerical value for generating a constant \code{ddmatrix}.}
}
\description{
At-scale verification routines for distributed linear algebra.
}
\details{
These routines numerically verify the accuracy of the given
operation.  Each operation generates only the local data that
is needed, and one never needs to store the global problem on
any one rank (unless \code{bldim} is set inappropriately).

For example, \code{verify.solve()} will generate the \code{A}
matrix and "true solution" \code{x} to the problem \code{Ax=b},
each as distributed objects.  Next, the "right hand side" \code{b}
is generated by multiplying \code{A} and \code{x} together.
Finally, the numericaly solution \code{x} is computed and compared
against the known true value at the specified numerical tolerance.
}
\keyword{Timing}

