% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{wafv2}
\alias{wafv2}
\title{AWS WAFV2}
\usage{
wafv2(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
WAF

This is the latest version of the \strong{WAF} API, released in November,
2019. The names of the entities that you use to access this API, like
endpoints and namespaces, all have the versioning information added,
like "V2" or "v2", to distinguish from the prior version. We recommend
migrating your resources to this version, because it has a number of
significant improvements.

If you used WAF prior to this release, you can't use this WAFV2 API to
access any WAF resources that you created before. You can access your
old rules, web ACLs, and other WAF resources only through the WAF
Classic APIs. The WAF Classic APIs have retained the prior names,
endpoints, and namespaces.

For information, including how to migrate your WAF resources to this
version, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{WAF Developer Guide}.

WAF is a web application firewall that lets you monitor the HTTP and
HTTPS requests that are forwarded to Amazon CloudFront, an Amazon API
Gateway REST API, an Application Load Balancer, an AppSync GraphQL API,
or an Amazon Cognito user pool. WAF also lets you control access to your
content. Based on conditions that you specify, such as the IP addresses
that requests originate from or the values of query strings, the Amazon
API Gateway REST API, CloudFront distribution, the Application Load
Balancer, the AppSync GraphQL API, or the Amazon Cognito user pool
responds to requests either with the requested content or with an HTTP
403 status code (Forbidden). You also can configure CloudFront to return
a custom error page when a request is blocked.

This API guide is for developers who need detailed information about WAF
API actions, data types, and errors. For detailed information about WAF
features and an overview of how to use WAF, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html}{WAF Developer Guide}.

You can make calls using the endpoints listed in \href{https://docs.aws.amazon.com/general/latest/gr/waf.html}{WAF endpoints and quotas}.
\itemize{
\item For regional applications, you can use any of the endpoints in the
list. A regional application can be an Application Load Balancer
(ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an
Amazon Cognito user pool.
\item For Amazon CloudFront applications, you must use the API endpoint
listed for US East (N. Virginia): us-east-1.
}

Alternatively, you can use one of the Amazon Web Services SDKs to access
an API that's tailored to the programming language or platform that
you're using. For more information, see \href{https://aws.amazon.com/developer/tools/#SDKs}{Amazon Web Services SDKs}.

We currently provide two versions of the WAF API: this API and the prior
versions, the classic WAF APIs. This new API provides the same
functionality as the older versions, with the following major
improvements:
\itemize{
\item You use one API for both global and regional applications. Where you
need to distinguish the scope, you specify a \code{Scope} parameter and
set it to \code{CLOUDFRONT} or \code{REGIONAL}.
\item You can define a web ACL or rule group with a single call, and
update it with a single call. You define all rule specifications in
JSON format, and pass them to your rule group or web ACL calls.
\item The limits WAF places on the use of rules more closely reflects the
cost of running each type of rule. Rule groups include capacity
settings, so you know the maximum cost of a rule group when you use
it.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- wafv2(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:wafv2_associate_web_acl]{associate_web_acl} \tab Associates a web ACL with a regional application resource, to protect the resource\cr
\link[paws.security.identity:wafv2_check_capacity]{check_capacity} \tab Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules\cr
\link[paws.security.identity:wafv2_create_ip_set]{create_ip_set} \tab Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses\cr
\link[paws.security.identity:wafv2_create_regex_pattern_set]{create_regex_pattern_set} \tab Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns\cr
\link[paws.security.identity:wafv2_create_rule_group]{create_rule_group} \tab Creates a RuleGroup per the specifications provided\cr
\link[paws.security.identity:wafv2_create_web_acl]{create_web_acl} \tab Creates a WebACL per the specifications provided\cr
\link[paws.security.identity:wafv2_delete_firewall_manager_rule_groups]{delete_firewall_manager_rule_groups} \tab Deletes all rule groups that are managed by Firewall Manager for the specified web ACL\cr
\link[paws.security.identity:wafv2_delete_ip_set]{delete_ip_set} \tab Deletes the specified IPSet\cr
\link[paws.security.identity:wafv2_delete_logging_configuration]{delete_logging_configuration} \tab Deletes the LoggingConfiguration from the specified web ACL\cr
\link[paws.security.identity:wafv2_delete_permission_policy]{delete_permission_policy} \tab Permanently deletes an IAM policy from the specified rule group\cr
\link[paws.security.identity:wafv2_delete_regex_pattern_set]{delete_regex_pattern_set} \tab Deletes the specified RegexPatternSet\cr
\link[paws.security.identity:wafv2_delete_rule_group]{delete_rule_group} \tab Deletes the specified RuleGroup\cr
\link[paws.security.identity:wafv2_delete_web_acl]{delete_web_acl} \tab Deletes the specified WebACL\cr
\link[paws.security.identity:wafv2_describe_managed_rule_group]{describe_managed_rule_group} \tab Provides high-level information for a managed rule group, including descriptions of the rules\cr
\link[paws.security.identity:wafv2_disassociate_web_acl]{disassociate_web_acl} \tab Disassociates the specified regional application resource from any existing web ACL association\cr
\link[paws.security.identity:wafv2_generate_mobile_sdk_release_url]{generate_mobile_sdk_release_url} \tab Generates a presigned download URL for the specified release of the mobile SDK\cr
\link[paws.security.identity:wafv2_get_ip_set]{get_ip_set} \tab Retrieves the specified IPSet\cr
\link[paws.security.identity:wafv2_get_logging_configuration]{get_logging_configuration} \tab Returns the LoggingConfiguration for the specified web ACL\cr
\link[paws.security.identity:wafv2_get_managed_rule_set]{get_managed_rule_set} \tab Retrieves the specified managed rule set\cr
\link[paws.security.identity:wafv2_get_mobile_sdk_release]{get_mobile_sdk_release} \tab Retrieves information for the specified mobile SDK release, including release notes and tags\cr
\link[paws.security.identity:wafv2_get_permission_policy]{get_permission_policy} \tab Returns the IAM policy that is attached to the specified rule group\cr
\link[paws.security.identity:wafv2_get_rate_based_statement_managed_keys]{get_rate_based_statement_managed_keys} \tab Retrieves the keys that are currently blocked by a rate-based rule instance\cr
\link[paws.security.identity:wafv2_get_regex_pattern_set]{get_regex_pattern_set} \tab Retrieves the specified RegexPatternSet\cr
\link[paws.security.identity:wafv2_get_rule_group]{get_rule_group} \tab Retrieves the specified RuleGroup\cr
\link[paws.security.identity:wafv2_get_sampled_requests]{get_sampled_requests} \tab Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose\cr
\link[paws.security.identity:wafv2_get_web_acl]{get_web_acl} \tab Retrieves the specified WebACL\cr
\link[paws.security.identity:wafv2_get_web_acl_for_resource]{get_web_acl_for_resource} \tab Retrieves the WebACL for the specified resource\cr
\link[paws.security.identity:wafv2_list_available_managed_rule_groups]{list_available_managed_rule_groups} \tab Retrieves an array of managed rule groups that are available for you to use\cr
\link[paws.security.identity:wafv2_list_available_managed_rule_group_versions]{list_available_managed_rule_group_versions} \tab Returns a list of the available versions for the specified managed rule group\cr
\link[paws.security.identity:wafv2_list_ip_sets]{list_ip_sets} \tab Retrieves an array of IPSetSummary objects for the IP sets that you manage\cr
\link[paws.security.identity:wafv2_list_logging_configurations]{list_logging_configurations} \tab Retrieves an array of your LoggingConfiguration objects\cr
\link[paws.security.identity:wafv2_list_managed_rule_sets]{list_managed_rule_sets} \tab Retrieves the managed rule sets that you own\cr
\link[paws.security.identity:wafv2_list_mobile_sdk_releases]{list_mobile_sdk_releases} \tab Retrieves a list of the available releases for the mobile SDK and the specified device platform\cr
\link[paws.security.identity:wafv2_list_regex_pattern_sets]{list_regex_pattern_sets} \tab Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage\cr
\link[paws.security.identity:wafv2_list_resources_for_web_acl]{list_resources_for_web_acl} \tab Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL\cr
\link[paws.security.identity:wafv2_list_rule_groups]{list_rule_groups} \tab Retrieves an array of RuleGroupSummary objects for the rule groups that you manage\cr
\link[paws.security.identity:wafv2_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves the TagInfoForResource for the specified resource\cr
\link[paws.security.identity:wafv2_list_web_ac_ls]{list_web_ac_ls} \tab Retrieves an array of WebACLSummary objects for the web ACLs that you manage\cr
\link[paws.security.identity:wafv2_put_logging_configuration]{put_logging_configuration} \tab Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided\cr
\link[paws.security.identity:wafv2_put_managed_rule_set_versions]{put_managed_rule_set_versions} \tab Defines the versions of your managed rule set that you are offering to the customers\cr
\link[paws.security.identity:wafv2_put_permission_policy]{put_permission_policy} \tab Attaches an IAM policy to the specified resource\cr
\link[paws.security.identity:wafv2_tag_resource]{tag_resource} \tab Associates tags with the specified Amazon Web Services resource\cr
\link[paws.security.identity:wafv2_untag_resource]{untag_resource} \tab Disassociates tags from an Amazon Web Services resource\cr
\link[paws.security.identity:wafv2_update_ip_set]{update_ip_set} \tab Updates the specified IPSet\cr
\link[paws.security.identity:wafv2_update_managed_rule_set_version_expiry_date]{update_managed_rule_set_version_expiry_date} \tab Updates the expiration information for your managed rule set\cr
\link[paws.security.identity:wafv2_update_regex_pattern_set]{update_regex_pattern_set} \tab Updates the specified RegexPatternSet\cr
\link[paws.security.identity:wafv2_update_rule_group]{update_rule_group} \tab Updates the specified RuleGroup\cr
\link[paws.security.identity:wafv2_update_web_acl]{update_web_acl} \tab Updates the specified WebACL
}
}

\examples{
\dontrun{
svc <- wafv2()
svc$associate_web_acl(
  Foo = 123
)
}

}
