% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{athena}
\alias{athena}
\title{Amazon Athena}
\usage{
athena()
}
\description{
Amazon Athena is an interactive query service that lets you use standard
SQL to analyze data directly in Amazon S3. You can point Athena at your
data in Amazon S3 and run ad-hoc queries and get results in seconds.
Athena is serverless, so there is no infrastructure to set up or manage.
You pay only for the queries you run. Athena scales
automatically---executing queries in parallel---so results are fast,
even with large datasets and complex queries. For more information, see
\href{http://docs.aws.amazon.com/athena/latest/ug/what-is.html}{What is Amazon Athena} in the
\emph{Amazon Athena User Guide}.

If you connect to Athena using the JDBC driver, use version 1.1.0 of the
driver or later with the Amazon Athena API. Earlier version drivers do
not support the API. For more information and to download the driver,
see \href{https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html}{Accessing Amazon Athena with JDBC}.

For code samples using the AWS SDK for Java, see \href{https://docs.aws.amazon.com/athena/latest/ug/code-samples.html}{Examples and Code Samples}
in the \emph{Amazon Athena User Guide}.
}
\section{Operations}{

\tabular{ll}{
\link[=athena_batch_get_named_query]{batch_get_named_query} \tab Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings \cr
\link[=athena_batch_get_query_execution]{batch_get_query_execution} \tab Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings\cr
\link[=athena_create_named_query]{create_named_query} \tab Creates a named query in the specified workgroup \cr
\link[=athena_create_work_group]{create_work_group} \tab Creates a workgroup with the specified name \cr
\link[=athena_delete_named_query]{delete_named_query} \tab Deletes the named query if you have access to the workgroup in which the query was saved \cr
\link[=athena_delete_work_group]{delete_work_group} \tab Deletes the workgroup with the specified name \cr
\link[=athena_get_named_query]{get_named_query} \tab Returns information about a single query \cr
\link[=athena_get_query_execution]{get_query_execution} \tab Returns information about a single execution of a query if you have access to the workgroup in which the query ran \cr
\link[=athena_get_query_results]{get_query_results} \tab Returns the results of a single query execution specified by QueryExecutionId if you have access to the workgroup in which the query ran \cr
\link[=athena_get_work_group]{get_work_group} \tab Returns information about the workgroup with the specified name \cr
\link[=athena_list_named_queries]{list_named_queries} \tab Provides a list of available query IDs only for queries saved in the specified workgroup \cr
\link[=athena_list_query_executions]{list_query_executions} \tab Provides a list of available query execution IDs for the queries in the specified workgroup \cr
\link[=athena_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags associated with this workgroup \cr
\link[=athena_list_work_groups]{list_work_groups} \tab Lists available workgroups for the account \cr
\link[=athena_start_query_execution]{start_query_execution} \tab Runs the SQL query statements contained in the Query \cr
\link[=athena_stop_query_execution]{stop_query_execution} \tab Stops a query execution \cr
\link[=athena_tag_resource]{tag_resource} \tab Adds one or more tags to the resource, such as a workgroup \cr
\link[=athena_untag_resource]{untag_resource} \tab Removes one or more tags from the workgroup resource \cr
\link[=athena_update_work_group]{update_work_group} \tab Updates the workgroup with the specified name
}
}

\examples{
\donttest{svc <- athena()
svc$batch_get_named_query(
  Foo = 123
)}

}
