% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_create_dataset}
\alias{finspacedata_create_dataset}
\title{Creates a new FinSpace Dataset}
\usage{
finspacedata_create_dataset(
  clientToken = NULL,
  datasetTitle,
  kind,
  datasetDescription = NULL,
  ownerInfo = NULL,
  permissionGroupParams,
  alias = NULL,
  schemaDefinition = NULL
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{datasetTitle}{[required] Display title for a FinSpace Dataset.}

\item{kind}{[required] The format in which Dataset data is structured.
\itemize{
\item \code{TABULAR} – Data is structured in a tabular format.
\item \code{NON_TABULAR} – Data is structured in a non-tabular format.
}}

\item{datasetDescription}{Description of a Dataset.}

\item{ownerInfo}{Contact information for a Dataset owner.}

\item{permissionGroupParams}{[required] Permission group parameters for Dataset permissions.}

\item{alias}{The unique resource identifier for a Dataset.}

\item{schemaDefinition}{Definition for a schema on a tabular Dataset.}
}
\description{
Creates a new FinSpace Dataset.

See \url{https://www.paws-r-sdk.com/docs/finspacedata_create_dataset/} for full documentation.
}
\keyword{internal}
