# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3control_service.R
NULL

#' Associate your S3 Access Grants instance with an Amazon Web Services IAM
#' Identity Center instance
#'
#' @description
#' Associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance. Use this action if you want to create access grants for users or groups from your corporate identity directory. First, you must add your corporate identity directory to Amazon Web Services IAM Identity Center. Then, you can associate this IAM Identity Center instance with your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_associate_access_grants_identity_center/](https://www.paws-r-sdk.com/docs/s3control_associate_access_grants_identity_center/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param IdentityCenterArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity
#' Center instance that you are associating with your S3 Access Grants
#' instance. An IAM Identity Center instance is your corporate identity
#' directory that you added to the IAM Identity Center. You can use the
#' [ListInstances](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html)
#' API operation to retrieve a list of your Identity Center instances and
#' their ARNs.
#'
#' @keywords internal
#'
#' @rdname s3control_associate_access_grants_identity_center
s3control_associate_access_grants_identity_center <- function(AccountId, IdentityCenterArn) {
  op <- new_operation(
    name = "AssociateAccessGrantsIdentityCenter",
    http_method = "POST",
    http_path = "/v20180820/accessgrantsinstance/identitycenter",
    paginator = list()
  )
  input <- .s3control$associate_access_grants_identity_center_input(AccountId = AccountId, IdentityCenterArn = IdentityCenterArn)
  output <- .s3control$associate_access_grants_identity_center_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$associate_access_grants_identity_center <- s3control_associate_access_grants_identity_center

#' Creates an access grant that gives a grantee access to your S3 data
#'
#' @description
#' Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the [`create_access_grants_instance`][s3control_create_access_grants_instance]. You must also have registered at least one S3 data location in your S3 Access Grants instance using [`create_access_grants_location`][s3control_create_access_grants_location].
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_access_grant/](https://www.paws-r-sdk.com/docs/s3control_create_access_grant/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantsLocationId &#91;required&#93; The ID of the registered location to which you are granting access. S3
#' Access Grants assigns this ID when you register the location. S3 Access
#' Grants assigns the ID `default` to the default location `s3://` and
#' assigns an auto-generated ID to other locations that you register.
#' 
#' If you are passing the `default` location, you cannot create an access
#' grant for the entire default location. You must also specify a bucket or
#' a bucket and prefix in the `Subprefix` field.
#' @param AccessGrantsLocationConfiguration The configuration options of the grant location. The grant location is
#' the S3 path to the data to which you are granting access. It contains
#' the `S3SubPrefix` field. The grant scope is the result of appending the
#' subprefix to the location scope of the registered location.
#' @param Grantee &#91;required&#93; The user, group, or role to which you are granting access. You can grant
#' access to an IAM user or role. If you have added your corporate
#' directory to Amazon Web Services IAM Identity Center and associated your
#' Identity Center instance with your S3 Access Grants instance, the
#' grantee can also be a corporate directory user or group.
#' @param Permission &#91;required&#93; The type of access that you are granting to your S3 data, which can be
#' set to one of the following values:
#' 
#' -   `READ` – Grant read-only access to the S3 data.
#' 
#' -   `WRITE` – Grant write-only access to the S3 data.
#' 
#' -   `READWRITE` – Grant both read and write access to the S3 data.
#' @param ApplicationArn The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity
#' Center application associated with your Identity Center instance. If an
#' application ARN is included in the request to create an access grant,
#' the grantee can only access the S3 data through this application.
#' @param S3PrefixType The type of `S3SubPrefix`. The only possible value is `Object`. Pass
#' this value if the access grant scope is an object. Do not pass this
#' value if the access grant scope is a bucket or a bucket and a prefix.
#' @param Tags The Amazon Web Services resource tags that you are adding to the access
#' grant. Each tag is a label consisting of a user-defined key and value.
#' Tags can help you manage, identify, organize, search for, and filter
#' resources.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_grant
s3control_create_access_grant <- function(AccountId, AccessGrantsLocationId, AccessGrantsLocationConfiguration = NULL, Grantee, Permission, ApplicationArn = NULL, S3PrefixType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccessGrant",
    http_method = "POST",
    http_path = "/v20180820/accessgrantsinstance/grant",
    paginator = list()
  )
  input <- .s3control$create_access_grant_input(AccountId = AccountId, AccessGrantsLocationId = AccessGrantsLocationId, AccessGrantsLocationConfiguration = AccessGrantsLocationConfiguration, Grantee = Grantee, Permission = Permission, ApplicationArn = ApplicationArn, S3PrefixType = S3PrefixType, Tags = Tags)
  output <- .s3control$create_access_grant_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_grant <- s3control_create_access_grant

#' Creates an S3 Access Grants instance, which serves as a logical grouping
#' for access grants
#'
#' @description
#' Creates an S3 Access Grants instance, which serves as a logical grouping for access grants. You can create one S3 Access Grants instance per Region per account.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_access_grants_instance/](https://www.paws-r-sdk.com/docs/s3control_create_access_grants_instance/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param IdentityCenterArn If you would like to associate your S3 Access Grants instance with an
#' Amazon Web Services IAM Identity Center instance, use this field to pass
#' the Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity
#' Center instance that you are associating with your S3 Access Grants
#' instance. An IAM Identity Center instance is your corporate identity
#' directory that you added to the IAM Identity Center. You can use the
#' [ListInstances](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html)
#' API operation to retrieve a list of your Identity Center instances and
#' their ARNs.
#' @param Tags The Amazon Web Services resource tags that you are adding to the S3
#' Access Grants instance. Each tag is a label consisting of a user-defined
#' key and value. Tags can help you manage, identify, organize, search for,
#' and filter resources.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_grants_instance
s3control_create_access_grants_instance <- function(AccountId, IdentityCenterArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccessGrantsInstance",
    http_method = "POST",
    http_path = "/v20180820/accessgrantsinstance",
    paginator = list()
  )
  input <- .s3control$create_access_grants_instance_input(AccountId = AccountId, IdentityCenterArn = IdentityCenterArn, Tags = Tags)
  output <- .s3control$create_access_grants_instance_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_grants_instance <- s3control_create_access_grants_instance

#' The S3 data location that you would like to register in your S3 Access
#' Grants instance
#'
#' @description
#' The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in the same Region as your S3 Access Grants instance. The location can be one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_access_grants_location/](https://www.paws-r-sdk.com/docs/s3control_create_access_grants_location/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param LocationScope &#91;required&#93; The S3 path to the location that you are registering. The location scope
#' can be the default S3 location `s3://`, the S3 path to a bucket
#' `s3://<bucket>`, or the S3 path to a bucket and prefix
#' `s3://<bucket>/<prefix>`. A prefix in S3 is a string of characters at
#' the beginning of an object key name used to organize the objects that
#' you store in your S3 buckets. For example, object key names that start
#' with the `engineering/` prefix or object key names that start with the
#' `marketing/campaigns/` prefix.
#' @param IAMRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role for the registered
#' location. S3 Access Grants assumes this role to manage access to the
#' registered location.
#' @param Tags The Amazon Web Services resource tags that you are adding to the S3
#' Access Grants location. Each tag is a label consisting of a user-defined
#' key and value. Tags can help you manage, identify, organize, search for,
#' and filter resources.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_grants_location
s3control_create_access_grants_location <- function(AccountId, LocationScope, IAMRoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccessGrantsLocation",
    http_method = "POST",
    http_path = "/v20180820/accessgrantsinstance/location",
    paginator = list()
  )
  input <- .s3control$create_access_grants_location_input(AccountId = AccountId, LocationScope = LocationScope, IAMRoleArn = IAMRoleArn, Tags = Tags)
  output <- .s3control$create_access_grants_location_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_grants_location <- s3control_create_access_grants_location

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_access_point/](https://www.paws-r-sdk.com/docs/s3control_create_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the account that owns the
#' specified access point.
#' @param Name &#91;required&#93; The name you want to assign to this access point.
#' @param Bucket &#91;required&#93; The name of the bucket that you want to associate this access point
#' with.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param VpcConfiguration If you include this field, Amazon S3 restricts access to this access
#' point to requests from the specified virtual private cloud (VPC).
#' 
#' This is required for creating an access point for Amazon S3 on Outposts
#' buckets.
#' @param PublicAccessBlockConfiguration The `PublicAccessBlock` configuration that you want to apply to the
#' access point.
#' @param BucketAccountId The Amazon Web Services account ID associated with the S3 bucket
#' associated with this access point.
#' 
#' For same account access point when your bucket and access point belong
#' to the same account owner, the `BucketAccountId` is not required. For
#' cross-account access point when your bucket and access point are not in
#' the same account, the `BucketAccountId` is required.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_point
s3control_create_access_point <- function(AccountId, Name, Bucket, VpcConfiguration = NULL, PublicAccessBlockConfiguration = NULL, BucketAccountId = NULL) {
  op <- new_operation(
    name = "CreateAccessPoint",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$create_access_point_input(AccountId = AccountId, Name = Name, Bucket = Bucket, VpcConfiguration = VpcConfiguration, PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, BucketAccountId = BucketAccountId)
  output <- .s3control$create_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_point <- s3control_create_access_point

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_access_point_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_create_access_point_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for owner of the specified Object
#' Lambda Access Point.
#' @param Name &#91;required&#93; The name you want to assign to this Object Lambda Access Point.
#' @param Configuration &#91;required&#93; Object Lambda Access Point configuration as a JSON document.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_point_for_object_lambda
s3control_create_access_point_for_object_lambda <- function(AccountId, Name, Configuration) {
  op <- new_operation(
    name = "CreateAccessPointForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$create_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name, Configuration = Configuration)
  output <- .s3control$create_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_point_for_object_lambda <- s3control_create_access_point_for_object_lambda

#' This action creates an Amazon S3 on Outposts bucket
#'
#' @description
#' This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see [Create Bucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_bucket/](https://www.paws-r-sdk.com/docs/s3control_create_bucket/) for full documentation.
#'
#' @param ACL The canned ACL to apply to the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param Bucket &#91;required&#93; The name of the bucket.
#' @param CreateBucketConfiguration The configuration information for the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantWrite Allows grantee to create, overwrite, and delete any object in the
#' bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param ObjectLockEnabledForBucket Specifies whether you want S3 Object Lock to be enabled for the new
#' bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param OutpostId The ID of the Outposts where the bucket is being created.
#' 
#' This ID is required by Amazon S3 on Outposts buckets.
#'
#' @keywords internal
#'
#' @rdname s3control_create_bucket
s3control_create_bucket <- function(ACL = NULL, Bucket, CreateBucketConfiguration = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, ObjectLockEnabledForBucket = NULL, OutpostId = NULL) {
  op <- new_operation(
    name = "CreateBucket",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$create_bucket_input(ACL = ACL, Bucket = Bucket, CreateBucketConfiguration = CreateBucketConfiguration, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, ObjectLockEnabledForBucket = ObjectLockEnabledForBucket, OutpostId = OutpostId)
  output <- .s3control$create_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_bucket <- s3control_create_bucket

#' This operation creates an S3 Batch Operations job
#'
#' @description
#' This operation creates an S3 Batch Operations job.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_job/](https://www.paws-r-sdk.com/docs/s3control_create_job/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that creates the job.
#' @param ConfirmationRequired Indicates whether confirmation is required before Amazon S3 runs the
#' job. Confirmation is only required for jobs created through the Amazon
#' S3 console.
#' @param Operation &#91;required&#93; The action that you want this job to perform on every object listed in
#' the manifest. For more information about the available actions, see
#' [Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/) in
#' the *Amazon S3 User Guide*.
#' @param Report &#91;required&#93; Configuration parameters for the optional job-completion report.
#' @param ClientRequestToken &#91;required&#93; An idempotency token to ensure that you don't accidentally submit the
#' same request twice. You can use any string up to the maximum length.
#' @param Manifest Configuration parameters for the manifest.
#' @param Description A description for this job. You can use any string within the permitted
#' length. Descriptions don't need to be unique and can be used for
#' multiple jobs.
#' @param Priority &#91;required&#93; The numerical priority for this job. Higher numbers indicate higher
#' priority.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) for the Identity and Access Management
#' (IAM) role that Batch Operations will use to run this job's action on
#' every object in the manifest.
#' @param Tags A set of tags to associate with the S3 Batch Operations job. This is an
#' optional parameter.
#' @param ManifestGenerator The attribute container for the ManifestGenerator details. Jobs must be
#' created with either a manifest file or a ManifestGenerator, but not
#' both.
#'
#' @keywords internal
#'
#' @rdname s3control_create_job
s3control_create_job <- function(AccountId, ConfirmationRequired = NULL, Operation, Report, ClientRequestToken, Manifest = NULL, Description = NULL, Priority, RoleArn, Tags = NULL, ManifestGenerator = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/v20180820/jobs",
    paginator = list()
  )
  input <- .s3control$create_job_input(AccountId = AccountId, ConfirmationRequired = ConfirmationRequired, Operation = Operation, Report = Report, ClientRequestToken = ClientRequestToken, Manifest = Manifest, Description = Description, Priority = Priority, RoleArn = RoleArn, Tags = Tags, ManifestGenerator = ManifestGenerator)
  output <- .s3control$create_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_job <- s3control_create_job

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_multi_region_access_point/](https://www.paws-r-sdk.com/docs/s3control_create_multi_region_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point. The owner of the Multi-Region Access Point also must own
#' the underlying buckets.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing details about the Multi-Region Access
#' Point.
#'
#' @keywords internal
#'
#' @rdname s3control_create_multi_region_access_point
s3control_create_multi_region_access_point <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "CreateMultiRegionAccessPoint",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/create",
    paginator = list()
  )
  input <- .s3control$create_multi_region_access_point_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$create_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_multi_region_access_point <- s3control_create_multi_region_access_point

#' Creates a new S3 Storage Lens group and associates it with the specified
#' Amazon Web Services account ID
#'
#' @description
#' Creates a new S3 Storage Lens group and associates it with the specified Amazon Web Services account ID. An S3 Storage Lens group is a custom grouping of objects based on prefix, suffix, object tags, object size, object age, or a combination of these filters. For each Storage Lens group that you’ve created, you can also optionally add Amazon Web Services resource tags. For more information about S3 Storage Lens groups, see [Working with S3 Storage Lens groups](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html).
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_create_storage_lens_group/](https://www.paws-r-sdk.com/docs/s3control_create_storage_lens_group/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that the Storage Lens group is
#' created from and associated with.
#' @param StorageLensGroup &#91;required&#93; The Storage Lens group configuration.
#' @param Tags The Amazon Web Services resource tags that you're adding to your Storage
#' Lens group. This parameter is optional.
#'
#' @keywords internal
#'
#' @rdname s3control_create_storage_lens_group
s3control_create_storage_lens_group <- function(AccountId, StorageLensGroup, Tags = NULL) {
  op <- new_operation(
    name = "CreateStorageLensGroup",
    http_method = "POST",
    http_path = "/v20180820/storagelensgroup",
    paginator = list()
  )
  input <- .s3control$create_storage_lens_group_input(AccountId = AccountId, StorageLensGroup = StorageLensGroup, Tags = Tags)
  output <- .s3control$create_storage_lens_group_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_storage_lens_group <- s3control_create_storage_lens_group

#' Deletes the access grant from the S3 Access Grants instance
#'
#' @description
#' Deletes the access grant from the S3 Access Grants instance. You cannot undo an access grant deletion and the grantee will no longer have access to the S3 data.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_grant/](https://www.paws-r-sdk.com/docs/s3control_delete_access_grant/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantId &#91;required&#93; The ID of the access grant. S3 Access Grants auto-generates this ID when
#' you create the access grant.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_grant
s3control_delete_access_grant <- function(AccountId, AccessGrantId) {
  op <- new_operation(
    name = "DeleteAccessGrant",
    http_method = "DELETE",
    http_path = "/v20180820/accessgrantsinstance/grant/{id}",
    paginator = list()
  )
  input <- .s3control$delete_access_grant_input(AccountId = AccountId, AccessGrantId = AccessGrantId)
  output <- .s3control$delete_access_grant_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_grant <- s3control_delete_access_grant

#' Deletes your S3 Access Grants instance
#'
#' @description
#' Deletes your S3 Access Grants instance. You must first delete the access grants and locations before S3 Access Grants can delete the instance. See [`delete_access_grant`][s3control_delete_access_grant] and [`delete_access_grants_location`][s3control_delete_access_grants_location]. If you have associated an IAM Identity Center instance with your S3 Access Grants instance, you must first dissassociate the Identity Center instance from the S3 Access Grants instance before you can delete the S3 Access Grants instance. See [`associate_access_grants_identity_center`][s3control_associate_access_grants_identity_center] and [`dissociate_access_grants_identity_center`][s3control_dissociate_access_grants_identity_center].
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_instance/](https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_instance/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_grants_instance
s3control_delete_access_grants_instance <- function(AccountId) {
  op <- new_operation(
    name = "DeleteAccessGrantsInstance",
    http_method = "DELETE",
    http_path = "/v20180820/accessgrantsinstance",
    paginator = list()
  )
  input <- .s3control$delete_access_grants_instance_input(AccountId = AccountId)
  output <- .s3control$delete_access_grants_instance_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_grants_instance <- s3control_delete_access_grants_instance

#' Deletes the resource policy of the S3 Access Grants instance
#'
#' @description
#' Deletes the resource policy of the S3 Access Grants instance. The resource policy is used to manage cross-account access to your S3 Access Grants instance. By deleting the resource policy, you delete any cross-account permissions to your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_instance_resource_policy/](https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_instance_resource_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_grants_instance_resource_policy
s3control_delete_access_grants_instance_resource_policy <- function(AccountId) {
  op <- new_operation(
    name = "DeleteAccessGrantsInstanceResourcePolicy",
    http_method = "DELETE",
    http_path = "/v20180820/accessgrantsinstance/resourcepolicy",
    paginator = list()
  )
  input <- .s3control$delete_access_grants_instance_resource_policy_input(AccountId = AccountId)
  output <- .s3control$delete_access_grants_instance_resource_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_grants_instance_resource_policy <- s3control_delete_access_grants_instance_resource_policy

#' Deregisters a location from your S3 Access Grants instance
#'
#' @description
#' Deregisters a location from your S3 Access Grants instance. You can only delete a location registration from an S3 Access Grants instance if there are no grants associated with this location. See [Delete a grant](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html) for information on how to delete grants. You need to have at least one registered location in your S3 Access Grants instance in order to create access grants.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_location/](https://www.paws-r-sdk.com/docs/s3control_delete_access_grants_location/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantsLocationId &#91;required&#93; The ID of the registered location that you are deregistering from your
#' S3 Access Grants instance. S3 Access Grants assigned this ID when you
#' registered the location. S3 Access Grants assigns the ID `default` to
#' the default location `s3://` and assigns an auto-generated ID to other
#' locations that you register.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_grants_location
s3control_delete_access_grants_location <- function(AccountId, AccessGrantsLocationId) {
  op <- new_operation(
    name = "DeleteAccessGrantsLocation",
    http_method = "DELETE",
    http_path = "/v20180820/accessgrantsinstance/location/{id}",
    paginator = list()
  )
  input <- .s3control$delete_access_grants_location_input(AccountId = AccountId, AccessGrantsLocationId = AccessGrantsLocationId)
  output <- .s3control$delete_access_grants_location_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_grants_location <- s3control_delete_access_grants_location

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_point/](https://www.paws-r-sdk.com/docs/s3control_delete_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the account that owns the
#' specified access point.
#' @param Name &#91;required&#93; The name of the access point you want to delete.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through Outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point
s3control_delete_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPoint",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$delete_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point <- s3control_delete_access_point

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_point_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_delete_access_point_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the access point you want to delete.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_for_object_lambda
s3control_delete_access_point_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointForObjectLambda",
    http_method = "DELETE",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$delete_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_for_object_lambda <- s3control_delete_access_point_for_object_lambda

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_point_policy/](https://www.paws-r-sdk.com/docs/s3control_delete_access_point_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to delete.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through Outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_policy
s3control_delete_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointPolicy",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_policy <- s3control_delete_access_point_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_access_point_policy_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_delete_access_point_policy_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point you want to delete the policy
#' for.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_policy_for_object_lambda
s3control_delete_access_point_policy_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointPolicyForObjectLambda",
    http_method = "DELETE",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_policy_for_object_lambda <- s3control_delete_access_point_policy_for_object_lambda

#' This action deletes an Amazon S3 on Outposts bucket
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see [`delete_bucket`][s3control_delete_bucket] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_bucket/](https://www.paws-r-sdk.com/docs/s3control_delete_bucket/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID that owns the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket being deleted.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket
s3control_delete_bucket <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucket",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$delete_bucket_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket <- s3control_delete_bucket

#' This action deletes an Amazon S3 on Outposts bucket's lifecycle
#' configuration
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle configuration, see [DeleteBucketLifecycle](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html) in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_bucket_lifecycle_configuration/](https://www.paws-r-sdk.com/docs/s3control_delete_bucket_lifecycle_configuration/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the lifecycle configuration to delete.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_lifecycle_configuration
s3control_delete_bucket_lifecycle_configuration <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketLifecycleConfiguration",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$delete_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_lifecycle_configuration <- s3control_delete_bucket_lifecycle_configuration

#' This action deletes an Amazon S3 on Outposts bucket policy
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see [`delete_bucket_policy`][s3control_delete_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_bucket_policy/](https://www.paws-r-sdk.com/docs/s3control_delete_bucket_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_policy
s3control_delete_bucket_policy <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketPolicy",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_bucket_policy_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_policy <- s3control_delete_bucket_policy

#' This operation deletes an Amazon S3 on Outposts bucket's replication
#' configuration
#'
#' @description
#' This operation deletes an Amazon S3 on Outposts bucket's replication configuration. To delete an S3 bucket's replication configuration, see [`delete_bucket_replication`][s3control_delete_bucket_replication] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_bucket_replication/](https://www.paws-r-sdk.com/docs/s3control_delete_bucket_replication/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket to delete the
#' replication configuration for.
#' @param Bucket &#91;required&#93; Specifies the S3 on Outposts bucket to delete the replication
#' configuration for.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_replication
s3control_delete_bucket_replication <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketReplication",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/replication",
    paginator = list()
  )
  input <- .s3control$delete_bucket_replication_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_replication_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_replication <- s3control_delete_bucket_replication

#' This action deletes an Amazon S3 on Outposts bucket's tags
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see [`delete_bucket_tagging`][s3control_delete_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_bucket_tagging/](https://www.paws-r-sdk.com/docs/s3control_delete_bucket_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket tag set to be
#' removed.
#' @param Bucket &#91;required&#93; The bucket ARN that has the tag set to be removed.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_tagging
s3control_delete_bucket_tagging <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketTagging",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_tagging <- s3control_delete_bucket_tagging

#' Removes the entire tag set from the specified S3 Batch Operations job
#'
#' @description
#' Removes the entire tag set from the specified S3 Batch Operations job.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_job_tagging/](https://www.paws-r-sdk.com/docs/s3control_delete_job_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to delete.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_job_tagging
s3control_delete_job_tagging <- function(AccountId, JobId) {
  op <- new_operation(
    name = "DeleteJobTagging",
    http_method = "DELETE",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_job_tagging_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$delete_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_job_tagging <- s3control_delete_job_tagging

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_multi_region_access_point/](https://www.paws-r-sdk.com/docs/s3control_delete_multi_region_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing details about the Multi-Region Access
#' Point.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_multi_region_access_point
s3control_delete_multi_region_access_point <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "DeleteMultiRegionAccessPoint",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/delete",
    paginator = list()
  )
  input <- .s3control$delete_multi_region_access_point_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$delete_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_multi_region_access_point <- s3control_delete_multi_region_access_point

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_public_access_block/](https://www.paws-r-sdk.com/docs/s3control_delete_public_access_block/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to remove.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_public_access_block
s3control_delete_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$delete_public_access_block_input(AccountId = AccountId)
  output <- .s3control$delete_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_public_access_block <- s3control_delete_public_access_block

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_configuration/](https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_configuration/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_storage_lens_configuration
s3control_delete_storage_lens_configuration <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "DeleteStorageLensConfiguration",
    http_method = "DELETE",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$delete_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$delete_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_storage_lens_configuration <- s3control_delete_storage_lens_configuration

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_configuration_tagging/](https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_configuration_tagging/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_storage_lens_configuration_tagging
s3control_delete_storage_lens_configuration_tagging <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "DeleteStorageLensConfigurationTagging",
    http_method = "DELETE",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$delete_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_storage_lens_configuration_tagging <- s3control_delete_storage_lens_configuration_tagging

#' Deletes an existing S3 Storage Lens group
#'
#' @description
#' Deletes an existing S3 Storage Lens group.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_group/](https://www.paws-r-sdk.com/docs/s3control_delete_storage_lens_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Storage Lens group that you're trying to delete.
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID used to create the Storage Lens group
#' that you're trying to delete.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_storage_lens_group
s3control_delete_storage_lens_group <- function(Name, AccountId) {
  op <- new_operation(
    name = "DeleteStorageLensGroup",
    http_method = "DELETE",
    http_path = "/v20180820/storagelensgroup/{name}",
    paginator = list()
  )
  input <- .s3control$delete_storage_lens_group_input(Name = Name, AccountId = AccountId)
  output <- .s3control$delete_storage_lens_group_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_storage_lens_group <- s3control_delete_storage_lens_group

#' Retrieves the configuration parameters and status for a Batch Operations
#' job
#'
#' @description
#' Retrieves the configuration parameters and status for a Batch Operations job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_describe_job/](https://www.paws-r-sdk.com/docs/s3control_describe_job/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the job whose information you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_describe_job
s3control_describe_job <- function(AccountId, JobId) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/v20180820/jobs/{id}",
    paginator = list()
  )
  input <- .s3control$describe_job_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$describe_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$describe_job <- s3control_describe_job

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_describe_multi_region_access_point_operation/](https://www.paws-r-sdk.com/docs/s3control_describe_multi_region_access_point_operation/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param RequestTokenARN &#91;required&#93; The request token associated with the request you want to know about.
#' This request token is returned as part of the response when you make an
#' asynchronous request. You provide this token to query about the status
#' of the asynchronous action.
#'
#' @keywords internal
#'
#' @rdname s3control_describe_multi_region_access_point_operation
s3control_describe_multi_region_access_point_operation <- function(AccountId, RequestTokenARN) {
  op <- new_operation(
    name = "DescribeMultiRegionAccessPointOperation",
    http_method = "GET",
    http_path = "/v20180820/async-requests/mrap/{request_token+}",
    paginator = list()
  )
  input <- .s3control$describe_multi_region_access_point_operation_input(AccountId = AccountId, RequestTokenARN = RequestTokenARN)
  output <- .s3control$describe_multi_region_access_point_operation_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$describe_multi_region_access_point_operation <- s3control_describe_multi_region_access_point_operation

#' Dissociates the Amazon Web Services IAM Identity Center instance from
#' the S3 Access Grants instance
#'
#' @description
#' Dissociates the Amazon Web Services IAM Identity Center instance from the S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_dissociate_access_grants_identity_center/](https://www.paws-r-sdk.com/docs/s3control_dissociate_access_grants_identity_center/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#'
#' @keywords internal
#'
#' @rdname s3control_dissociate_access_grants_identity_center
s3control_dissociate_access_grants_identity_center <- function(AccountId) {
  op <- new_operation(
    name = "DissociateAccessGrantsIdentityCenter",
    http_method = "DELETE",
    http_path = "/v20180820/accessgrantsinstance/identitycenter",
    paginator = list()
  )
  input <- .s3control$dissociate_access_grants_identity_center_input(AccountId = AccountId)
  output <- .s3control$dissociate_access_grants_identity_center_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$dissociate_access_grants_identity_center <- s3control_dissociate_access_grants_identity_center

#' Get the details of an access grant from your S3 Access Grants instance
#'
#' @description
#' Get the details of an access grant from your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_grant/](https://www.paws-r-sdk.com/docs/s3control_get_access_grant/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantId &#91;required&#93; The ID of the access grant. S3 Access Grants auto-generates this ID when
#' you create the access grant.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_grant
s3control_get_access_grant <- function(AccountId, AccessGrantId) {
  op <- new_operation(
    name = "GetAccessGrant",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/grant/{id}",
    paginator = list()
  )
  input <- .s3control$get_access_grant_input(AccountId = AccountId, AccessGrantId = AccessGrantId)
  output <- .s3control$get_access_grant_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_grant <- s3control_get_access_grant

#' Retrieves the S3 Access Grants instance for a Region in your account
#'
#' @description
#' Retrieves the S3 Access Grants instance for a Region in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance/](https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_grants_instance
s3control_get_access_grants_instance <- function(AccountId) {
  op <- new_operation(
    name = "GetAccessGrantsInstance",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance",
    paginator = list()
  )
  input <- .s3control$get_access_grants_instance_input(AccountId = AccountId)
  output <- .s3control$get_access_grants_instance_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_grants_instance <- s3control_get_access_grants_instance

#' Retrieve the S3 Access Grants instance that contains a particular prefix
#'
#' @description
#' Retrieve the S3 Access Grants instance that contains a particular prefix.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance_for_prefix/](https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance_for_prefix/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param S3Prefix &#91;required&#93; The S3 prefix of the access grants that you would like to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_grants_instance_for_prefix
s3control_get_access_grants_instance_for_prefix <- function(AccountId, S3Prefix) {
  op <- new_operation(
    name = "GetAccessGrantsInstanceForPrefix",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/prefix",
    paginator = list()
  )
  input <- .s3control$get_access_grants_instance_for_prefix_input(AccountId = AccountId, S3Prefix = S3Prefix)
  output <- .s3control$get_access_grants_instance_for_prefix_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_grants_instance_for_prefix <- s3control_get_access_grants_instance_for_prefix

#' Returns the resource policy of the S3 Access Grants instance
#'
#' @description
#' Returns the resource policy of the S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance_resource_policy/](https://www.paws-r-sdk.com/docs/s3control_get_access_grants_instance_resource_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_grants_instance_resource_policy
s3control_get_access_grants_instance_resource_policy <- function(AccountId) {
  op <- new_operation(
    name = "GetAccessGrantsInstanceResourcePolicy",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/resourcepolicy",
    paginator = list()
  )
  input <- .s3control$get_access_grants_instance_resource_policy_input(AccountId = AccountId)
  output <- .s3control$get_access_grants_instance_resource_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_grants_instance_resource_policy <- s3control_get_access_grants_instance_resource_policy

#' Retrieves the details of a particular location registered in your S3
#' Access Grants instance
#'
#' @description
#' Retrieves the details of a particular location registered in your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_grants_location/](https://www.paws-r-sdk.com/docs/s3control_get_access_grants_location/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantsLocationId &#91;required&#93; The ID of the registered location that you are retrieving. S3 Access
#' Grants assigns this ID when you register the location. S3 Access Grants
#' assigns the ID `default` to the default location `s3://` and assigns an
#' auto-generated ID to other locations that you register.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_grants_location
s3control_get_access_grants_location <- function(AccountId, AccessGrantsLocationId) {
  op <- new_operation(
    name = "GetAccessGrantsLocation",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/location/{id}",
    paginator = list()
  )
  input <- .s3control$get_access_grants_location_input(AccountId = AccountId, AccessGrantsLocationId = AccessGrantsLocationId)
  output <- .s3control$get_access_grants_location_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_grants_location <- s3control_get_access_grants_location

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point/](https://www.paws-r-sdk.com/docs/s3control_get_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the account that owns the
#' specified access point.
#' @param Name &#91;required&#93; The name of the access point whose configuration information you want to
#' retrieve.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through Outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point
s3control_get_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPoint",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$get_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point <- s3control_get_access_point

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_configuration_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_configuration_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point you want to return the
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_configuration_for_object_lambda
s3control_get_access_point_configuration_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointConfigurationForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/configuration",
    paginator = list()
  )
  input <- .s3control$get_access_point_configuration_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_configuration_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_configuration_for_object_lambda <- s3control_get_access_point_configuration_for_object_lambda

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_for_object_lambda
s3control_get_access_point_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$get_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_for_object_lambda <- s3control_get_access_point_for_object_lambda

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to retrieve.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through Outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy
s3control_get_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicy",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy <- s3control_get_access_point_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_for_object_lambda
s3control_get_access_point_policy_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_for_object_lambda <- s3control_get_access_point_policy_for_object_lambda

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_status/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_status/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy status you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_status
s3control_get_access_point_policy_status <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyStatus",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policyStatus",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_status_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_status <- s3control_get_access_point_policy_status

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_status_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_get_access_point_policy_status_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_status_for_object_lambda
s3control_get_access_point_policy_status_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyStatusForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policyStatus",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_status_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_status_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_status_for_object_lambda <- s3control_get_access_point_policy_status_for_object_lambda

#' Gets an Amazon S3 on Outposts bucket
#'
#' @description
#' Gets an Amazon S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket/](https://www.paws-r-sdk.com/docs/s3control_get_bucket/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket
s3control_get_bucket <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucket",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$get_bucket_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket <- s3control_get_bucket

#' This action gets an Amazon S3 on Outposts bucket's lifecycle
#' configuration
#'
#' @description
#' This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see [`get_bucket_lifecycle_configuration`][s3control_get_bucket_lifecycle_configuration] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket_lifecycle_configuration/](https://www.paws-r-sdk.com/docs/s3control_get_bucket_lifecycle_configuration/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The Amazon Resource Name (ARN) of the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_lifecycle_configuration
s3control_get_bucket_lifecycle_configuration <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketLifecycleConfiguration",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$get_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_lifecycle_configuration <- s3control_get_bucket_lifecycle_configuration

#' This action gets a bucket policy for an Amazon S3 on Outposts bucket
#'
#' @description
#' This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see [`get_bucket_policy`][s3control_get_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket_policy/](https://www.paws-r-sdk.com/docs/s3control_get_bucket_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_policy
s3control_get_bucket_policy <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketPolicy",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_bucket_policy_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_policy <- s3control_get_bucket_policy

#' This operation gets an Amazon S3 on Outposts bucket's replication
#' configuration
#'
#' @description
#' This operation gets an Amazon S3 on Outposts bucket's replication configuration. To get an S3 bucket's replication configuration, see [`get_bucket_replication`][s3control_get_bucket_replication] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket_replication/](https://www.paws-r-sdk.com/docs/s3control_get_bucket_replication/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket to get the replication information for.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_replication
s3control_get_bucket_replication <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketReplication",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/replication",
    paginator = list()
  )
  input <- .s3control$get_bucket_replication_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_replication_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_replication <- s3control_get_bucket_replication

#' This action gets an Amazon S3 on Outposts bucket's tags
#'
#' @description
#' This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see [`get_bucket_tagging`][s3control_get_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket_tagging/](https://www.paws-r-sdk.com/docs/s3control_get_bucket_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_tagging
s3control_get_bucket_tagging <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketTagging",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$get_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_tagging <- s3control_get_bucket_tagging

#' This operation returns the versioning state for S3 on Outposts buckets
#' only
#'
#' @description
#' This operation returns the versioning state for S3 on Outposts buckets only. To return the versioning state for an S3 bucket, see [`get_bucket_versioning`][s3control_get_bucket_versioning] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_bucket_versioning/](https://www.paws-r-sdk.com/docs/s3control_get_bucket_versioning/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the S3 on Outposts bucket.
#' @param Bucket &#91;required&#93; The S3 on Outposts bucket to return the versioning state for.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_versioning
s3control_get_bucket_versioning <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketVersioning",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/versioning",
    paginator = list()
  )
  input <- .s3control$get_bucket_versioning_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_versioning_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_versioning <- s3control_get_bucket_versioning

#' Returns a temporary access credential from S3 Access Grants to the
#' grantee or client application
#'
#' @description
#' Returns a temporary access credential from S3 Access Grants to the grantee or client application. The [temporary credential](https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html) is an Amazon Web Services STS token that grants them access to the S3 data.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_data_access/](https://www.paws-r-sdk.com/docs/s3control_get_data_access/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param Target &#91;required&#93; The S3 URI path of the data to which you are requesting temporary access
#' credentials. If the requesting account has an access grant for this
#' data, S3 Access Grants vends temporary access credentials in the
#' response.
#' @param Permission &#91;required&#93; The type of permission granted to your S3 data, which can be set to one
#' of the following values:
#' 
#' -   `READ` – Grant read-only access to the S3 data.
#' 
#' -   `WRITE` – Grant write-only access to the S3 data.
#' 
#' -   `READWRITE` – Grant both read and write access to the S3 data.
#' @param DurationSeconds The session duration, in seconds, of the temporary access credential
#' that S3 Access Grants vends to the grantee or client application. The
#' default value is 1 hour, but the grantee can specify a range from 900
#' seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee
#' requests a value higher than this maximum, the operation fails.
#' @param Privilege The scope of the temporary access credential that S3 Access Grants vends
#' to the grantee or client application.
#' 
#' -   `Default` – The scope of the returned temporary access token is the
#'     scope of the grant that is closest to the target scope.
#' 
#' -   `Minimal` – The scope of the returned temporary access token is the
#'     same as the requested target scope as long as the requested scope is
#'     the same as or a subset of the grant scope.
#' @param TargetType The type of `Target`. The only possible value is `Object`. Pass this
#' value if the target data that you would like to access is a path to an
#' object. Do not pass this value if the target data is a bucket or a
#' bucket and a prefix.
#'
#' @keywords internal
#'
#' @rdname s3control_get_data_access
s3control_get_data_access <- function(AccountId, Target, Permission, DurationSeconds = NULL, Privilege = NULL, TargetType = NULL) {
  op <- new_operation(
    name = "GetDataAccess",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/dataaccess",
    paginator = list()
  )
  input <- .s3control$get_data_access_input(AccountId = AccountId, Target = Target, Permission = Permission, DurationSeconds = DurationSeconds, Privilege = Privilege, TargetType = TargetType)
  output <- .s3control$get_data_access_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_data_access <- s3control_get_data_access

#' Returns the tags on an S3 Batch Operations job
#'
#' @description
#' Returns the tags on an S3 Batch Operations job.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_job_tagging/](https://www.paws-r-sdk.com/docs/s3control_get_job_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_job_tagging
s3control_get_job_tagging <- function(AccountId, JobId) {
  op <- new_operation(
    name = "GetJobTagging",
    http_method = "GET",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$get_job_tagging_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$get_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_job_tagging <- s3control_get_job_tagging

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point/](https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; The name of the Multi-Region Access Point whose configuration
#' information you want to receive. The name of the Multi-Region Access
#' Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Rules for naming Amazon S3 Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point
s3control_get_multi_region_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPoint",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name+}",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point <- s3control_get_multi_region_access_point

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_policy/](https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; Specifies the Multi-Region Access Point. The name of the Multi-Region
#' Access Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Rules for naming Amazon S3 Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point_policy
s3control_get_multi_region_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPointPolicy",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name+}/policy",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point_policy <- s3control_get_multi_region_access_point_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_policy_status/](https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_policy_status/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; Specifies the Multi-Region Access Point. The name of the Multi-Region
#' Access Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Rules for naming Amazon S3 Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point_policy_status
s3control_get_multi_region_access_point_policy_status <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPointPolicyStatus",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name+}/policystatus",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_policy_status_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_policy_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point_policy_status <- s3control_get_multi_region_access_point_policy_status

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_routes/](https://www.paws-r-sdk.com/docs/s3control_get_multi_region_access_point_routes/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Mrap &#91;required&#93; The Multi-Region Access Point ARN.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point_routes
s3control_get_multi_region_access_point_routes <- function(AccountId, Mrap) {
  op <- new_operation(
    name = "GetMultiRegionAccessPointRoutes",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{mrap+}/routes",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_routes_input(AccountId = AccountId, Mrap = Mrap)
  output <- .s3control$get_multi_region_access_point_routes_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point_routes <- s3control_get_multi_region_access_point_routes

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_public_access_block/](https://www.paws-r-sdk.com/docs/s3control_get_public_access_block/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_public_access_block
s3control_get_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$get_public_access_block_input(AccountId = AccountId)
  output <- .s3control$get_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_public_access_block <- s3control_get_public_access_block

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_configuration/](https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_configuration/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the Amazon S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_get_storage_lens_configuration
s3control_get_storage_lens_configuration <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "GetStorageLensConfiguration",
    http_method = "GET",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$get_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$get_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_storage_lens_configuration <- s3control_get_storage_lens_configuration

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_configuration_tagging/](https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_configuration_tagging/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the Amazon S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_get_storage_lens_configuration_tagging
s3control_get_storage_lens_configuration_tagging <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "GetStorageLensConfigurationTagging",
    http_method = "GET",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$get_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$get_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_storage_lens_configuration_tagging <- s3control_get_storage_lens_configuration_tagging

#' Retrieves the Storage Lens group configuration details
#'
#' @description
#' Retrieves the Storage Lens group configuration details.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_group/](https://www.paws-r-sdk.com/docs/s3control_get_storage_lens_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Storage Lens group that you're trying to retrieve the
#' configuration details for.
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the Storage Lens
#' group that you're trying to retrieve the details for.
#'
#' @keywords internal
#'
#' @rdname s3control_get_storage_lens_group
s3control_get_storage_lens_group <- function(Name, AccountId) {
  op <- new_operation(
    name = "GetStorageLensGroup",
    http_method = "GET",
    http_path = "/v20180820/storagelensgroup/{name}",
    paginator = list()
  )
  input <- .s3control$get_storage_lens_group_input(Name = Name, AccountId = AccountId)
  output <- .s3control$get_storage_lens_group_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_storage_lens_group <- s3control_get_storage_lens_group

#' Returns the list of access grants in your S3 Access Grants instance
#'
#' @description
#' Returns the list of access grants in your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_access_grants/](https://www.paws-r-sdk.com/docs/s3control_list_access_grants/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param NextToken A pagination token to request the next page of results. Pass this value
#' into a subsequent `List Access Grants` request in order to retrieve the
#' next page of results.
#' @param MaxResults The maximum number of access grants that you would like returned in the
#' `List Access Grants` response. If the results include the pagination
#' token `NextToken`, make another call using the `NextToken` to determine
#' if there are more results.
#' @param GranteeType The type of the grantee to which access has been granted. It can be one
#' of the following values:
#' 
#' -   `IAM` - An IAM user or role.
#' 
#' -   `DIRECTORY_USER` - Your corporate directory user. You can use this
#'     option if you have added your corporate identity directory to IAM
#'     Identity Center and associated the IAM Identity Center instance with
#'     your S3 Access Grants instance.
#' 
#' -   `DIRECTORY_GROUP` - Your corporate directory group. You can use this
#'     option if you have added your corporate identity directory to IAM
#'     Identity Center and associated the IAM Identity Center instance with
#'     your S3 Access Grants instance.
#' @param GranteeIdentifier The unique identifer of the `Grantee`. If the grantee type is `IAM`, the
#' identifier is the IAM Amazon Resource Name (ARN) of the user or role. If
#' the grantee type is a directory user or group, the identifier is 128-bit
#' universally unique identifier (UUID) in the format
#' `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`. You can obtain this UUID from
#' your Amazon Web Services IAM Identity Center instance.
#' @param Permission The type of permission granted to your S3 data, which can be set to one
#' of the following values:
#' 
#' -   `READ` – Grant read-only access to the S3 data.
#' 
#' -   `WRITE` – Grant write-only access to the S3 data.
#' 
#' -   `READWRITE` – Grant both read and write access to the S3 data.
#' @param GrantScope The S3 path of the data to which you are granting access. It is the
#' result of appending the `Subprefix` to the location scope.
#' @param ApplicationArn The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity
#' Center application associated with your Identity Center instance. If the
#' grant includes an application ARN, the grantee can only access the S3
#' data through this application.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_grants
s3control_list_access_grants <- function(AccountId, NextToken = NULL, MaxResults = NULL, GranteeType = NULL, GranteeIdentifier = NULL, Permission = NULL, GrantScope = NULL, ApplicationArn = NULL) {
  op <- new_operation(
    name = "ListAccessGrants",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/grants",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_access_grants_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults, GranteeType = GranteeType, GranteeIdentifier = GranteeIdentifier, Permission = Permission, GrantScope = GrantScope, ApplicationArn = ApplicationArn)
  output <- .s3control$list_access_grants_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_grants <- s3control_list_access_grants

#' Returns a list of S3 Access Grants instances
#'
#' @description
#' Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your individual access grants. You can only have one S3 Access Grants instance per Region per account.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_access_grants_instances/](https://www.paws-r-sdk.com/docs/s3control_list_access_grants_instances/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param NextToken A pagination token to request the next page of results. Pass this value
#' into a subsequent `List Access Grants Instances` request in order to
#' retrieve the next page of results.
#' @param MaxResults The maximum number of access grants that you would like returned in the
#' `List Access Grants` response. If the results include the pagination
#' token `NextToken`, make another call using the `NextToken` to determine
#' if there are more results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_grants_instances
s3control_list_access_grants_instances <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessGrantsInstances",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstances",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_access_grants_instances_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_grants_instances_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_grants_instances <- s3control_list_access_grants_instances

#' Returns a list of the locations registered in your S3 Access Grants
#' instance
#'
#' @description
#' Returns a list of the locations registered in your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_access_grants_locations/](https://www.paws-r-sdk.com/docs/s3control_list_access_grants_locations/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param NextToken A pagination token to request the next page of results. Pass this value
#' into a subsequent `List Access Grants Locations` request in order to
#' retrieve the next page of results.
#' @param MaxResults The maximum number of access grants that you would like returned in the
#' `List Access Grants` response. If the results include the pagination
#' token `NextToken`, make another call using the `NextToken` to determine
#' if there are more results.
#' @param LocationScope The S3 path to the location that you are registering. The location scope
#' can be the default S3 location `s3://`, the S3 path to a bucket
#' `s3://<bucket>`, or the S3 path to a bucket and prefix
#' `s3://<bucket>/<prefix>`. A prefix in S3 is a string of characters at
#' the beginning of an object key name used to organize the objects that
#' you store in your S3 buckets. For example, object key names that start
#' with the `engineering/` prefix or object key names that start with the
#' `marketing/campaigns/` prefix.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_grants_locations
s3control_list_access_grants_locations <- function(AccountId, NextToken = NULL, MaxResults = NULL, LocationScope = NULL) {
  op <- new_operation(
    name = "ListAccessGrantsLocations",
    http_method = "GET",
    http_path = "/v20180820/accessgrantsinstance/locations",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_access_grants_locations_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults, LocationScope = LocationScope)
  output <- .s3control$list_access_grants_locations_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_grants_locations <- s3control_list_access_grants_locations

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_access_points/](https://www.paws-r-sdk.com/docs/s3control_list_access_points/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the account that owns the
#' specified access points.
#' @param Bucket The name of the bucket whose associated access points you want to list.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param NextToken A continuation token. If a previous call to
#' [`list_access_points`][s3control_list_access_points] returned a
#' continuation token in the `NextToken` field, then providing that value
#' here causes Amazon S3 to retrieve the next page of results.
#' @param MaxResults The maximum number of access points that you want to include in the
#' list. If the specified bucket has more than this number of access
#' points, then the response will include a continuation token in the
#' `NextToken` field that you can use to retrieve the next page of access
#' points.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_points
s3control_list_access_points <- function(AccountId, Bucket = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPoints",
    http_method = "GET",
    http_path = "/v20180820/accesspoint",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_access_points_input(AccountId = AccountId, Bucket = Bucket, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_points_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_points <- s3control_list_access_points

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_access_points_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_list_access_points_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param NextToken If the list has more access points than can be returned in one call to
#' this API, this field contains a continuation token that you can provide
#' in subsequent calls to this API to retrieve additional access points.
#' @param MaxResults The maximum number of access points that you want to include in the
#' list. The response may contain fewer access points but will never
#' contain more. If there are more than this number of access points, then
#' the response will include a continuation token in the `NextToken` field
#' that you can use to retrieve the next page of access points.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_points_for_object_lambda
s3control_list_access_points_for_object_lambda <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPointsForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ObjectLambdaAccessPointList")
  )
  input <- .s3control$list_access_points_for_object_lambda_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_points_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_points_for_object_lambda <- s3control_list_access_points_for_object_lambda

#' Lists current S3 Batch Operations jobs as well as the jobs that have
#' ended within the last 90 days for the Amazon Web Services account making
#' the request
#'
#' @description
#' Lists current S3 Batch Operations jobs as well as the jobs that have ended within the last 90 days for the Amazon Web Services account making the request. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_jobs/](https://www.paws-r-sdk.com/docs/s3control_list_jobs/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobStatuses The `List Jobs` request returns jobs that match the statuses listed in
#' this element.
#' @param NextToken A pagination token to request the next page of results. Use the token
#' that Amazon S3 returned in the `NextToken` element of the
#' `ListJobsResult` from the previous `List Jobs` request.
#' @param MaxResults The maximum number of jobs that Amazon S3 will include in the
#' `List Jobs` response. If there are more jobs than this number, the
#' response will include a pagination token in the `NextToken` field to
#' enable you to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_jobs
s3control_list_jobs <- function(AccountId, JobStatuses = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/v20180820/jobs",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_jobs_input(AccountId = AccountId, JobStatuses = JobStatuses, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_jobs_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_jobs <- s3control_list_jobs

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_multi_region_access_points/](https://www.paws-r-sdk.com/docs/s3control_list_multi_region_access_points/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param NextToken Not currently used. Do not use this parameter.
#' @param MaxResults Not currently used. Do not use this parameter.
#'
#' @keywords internal
#'
#' @rdname s3control_list_multi_region_access_points
s3control_list_multi_region_access_points <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMultiRegionAccessPoints",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_multi_region_access_points_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_multi_region_access_points_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_multi_region_access_points <- s3control_list_multi_region_access_points

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_regional_buckets/](https://www.paws-r-sdk.com/docs/s3control_list_regional_buckets/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param NextToken 
#' @param MaxResults 
#' @param OutpostId The ID of the Outposts resource.
#' 
#' This ID is required by Amazon S3 on Outposts buckets.
#'
#' @keywords internal
#'
#' @rdname s3control_list_regional_buckets
s3control_list_regional_buckets <- function(AccountId, NextToken = NULL, MaxResults = NULL, OutpostId = NULL) {
  op <- new_operation(
    name = "ListRegionalBuckets",
    http_method = "GET",
    http_path = "/v20180820/bucket",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .s3control$list_regional_buckets_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults, OutpostId = OutpostId)
  output <- .s3control$list_regional_buckets_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_regional_buckets <- s3control_list_regional_buckets

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_storage_lens_configurations/](https://www.paws-r-sdk.com/docs/s3control_list_storage_lens_configurations/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param NextToken A pagination token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_storage_lens_configurations
s3control_list_storage_lens_configurations <- function(AccountId, NextToken = NULL) {
  op <- new_operation(
    name = "ListStorageLensConfigurations",
    http_method = "GET",
    http_path = "/v20180820/storagelens",
    paginator = list(input_token = "NextToken", output_token = "NextToken")
  )
  input <- .s3control$list_storage_lens_configurations_input(AccountId = AccountId, NextToken = NextToken)
  output <- .s3control$list_storage_lens_configurations_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_storage_lens_configurations <- s3control_list_storage_lens_configurations

#' Lists all the Storage Lens groups in the specified home Region
#'
#' @description
#' Lists all the Storage Lens groups in the specified home Region.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_storage_lens_groups/](https://www.paws-r-sdk.com/docs/s3control_list_storage_lens_groups/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that owns the Storage Lens groups.
#' @param NextToken The token for the next set of results, or `null` if there are no more
#' results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_storage_lens_groups
s3control_list_storage_lens_groups <- function(AccountId, NextToken = NULL) {
  op <- new_operation(
    name = "ListStorageLensGroups",
    http_method = "GET",
    http_path = "/v20180820/storagelensgroup",
    paginator = list(input_token = "NextToken", output_token = "NextToken")
  )
  input <- .s3control$list_storage_lens_groups_input(AccountId = AccountId, NextToken = NextToken)
  output <- .s3control$list_storage_lens_groups_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_storage_lens_groups <- s3control_list_storage_lens_groups

#' This operation allows you to list all the Amazon Web Services resource
#' tags for a specified resource
#'
#' @description
#' This operation allows you to list all the Amazon Web Services resource tags for a specified resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/s3control_list_tags_for_resource/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the resource owner.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 resource that you want to list
#' the tags for. The tagged resource can be an S3 Storage Lens group or S3
#' Access Grants instance, registered location, or grant.
#'
#' @keywords internal
#'
#' @rdname s3control_list_tags_for_resource
s3control_list_tags_for_resource <- function(AccountId, ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v20180820/tags/{resourceArn+}",
    paginator = list()
  )
  input <- .s3control$list_tags_for_resource_input(AccountId = AccountId, ResourceArn = ResourceArn)
  output <- .s3control$list_tags_for_resource_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_tags_for_resource <- s3control_list_tags_for_resource

#' Updates the resource policy of the S3 Access Grants instance
#'
#' @description
#' Updates the resource policy of the S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_access_grants_instance_resource_policy/](https://www.paws-r-sdk.com/docs/s3control_put_access_grants_instance_resource_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param Policy &#91;required&#93; The resource policy of the S3 Access Grants instance that you are
#' updating.
#' @param Organization The Organization of the resource policy of the S3 Access Grants
#' instance.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_grants_instance_resource_policy
s3control_put_access_grants_instance_resource_policy <- function(AccountId, Policy, Organization = NULL) {
  op <- new_operation(
    name = "PutAccessGrantsInstanceResourcePolicy",
    http_method = "PUT",
    http_path = "/v20180820/accessgrantsinstance/resourcepolicy",
    paginator = list()
  )
  input <- .s3control$put_access_grants_instance_resource_policy_input(AccountId = AccountId, Policy = Policy, Organization = Organization)
  output <- .s3control$put_access_grants_instance_resource_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_grants_instance_resource_policy <- s3control_put_access_grants_instance_resource_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_access_point_configuration_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_put_access_point_configuration_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#' @param Configuration &#91;required&#93; Object Lambda Access Point configuration document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_configuration_for_object_lambda
s3control_put_access_point_configuration_for_object_lambda <- function(AccountId, Name, Configuration) {
  op <- new_operation(
    name = "PutAccessPointConfigurationForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/configuration",
    paginator = list()
  )
  input <- .s3control$put_access_point_configuration_for_object_lambda_input(AccountId = AccountId, Name = Name, Configuration = Configuration)
  output <- .s3control$put_access_point_configuration_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_configuration_for_object_lambda <- s3control_put_access_point_configuration_for_object_lambda

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_access_point_policy/](https://www.paws-r-sdk.com/docs/s3control_put_access_point_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for owner of the bucket associated
#' with the specified access point.
#' @param Name &#91;required&#93; The name of the access point that you want to associate with the
#' specified policy.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through Outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#' @param Policy &#91;required&#93; The policy that you want to apply to the specified access point. For
#' more information about access point policies, see [Managing data access
#' with Amazon S3 access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_policy
s3control_put_access_point_policy <- function(AccountId, Name, Policy) {
  op <- new_operation(
    name = "PutAccessPointPolicy",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_access_point_policy_input(AccountId = AccountId, Name = Name, Policy = Policy)
  output <- .s3control$put_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_policy <- s3control_put_access_point_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_access_point_policy_for_object_lambda/](https://www.paws-r-sdk.com/docs/s3control_put_access_point_policy_for_object_lambda/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#' @param Policy &#91;required&#93; Object Lambda Access Point resource policy document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_policy_for_object_lambda
s3control_put_access_point_policy_for_object_lambda <- function(AccountId, Name, Policy) {
  op <- new_operation(
    name = "PutAccessPointPolicyForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name, Policy = Policy)
  output <- .s3control$put_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_policy_for_object_lambda <- s3control_put_access_point_policy_for_object_lambda

#' This action puts a lifecycle configuration to an Amazon S3 on Outposts
#' bucket
#'
#' @description
#' This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see [`put_bucket_lifecycle_configuration`][s3control_put_bucket_lifecycle_configuration] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_bucket_lifecycle_configuration/](https://www.paws-r-sdk.com/docs/s3control_put_bucket_lifecycle_configuration/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The name of the bucket for which to set the configuration.
#' @param LifecycleConfiguration Container for lifecycle rules. You can add as many as 1,000 rules.
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_lifecycle_configuration
s3control_put_bucket_lifecycle_configuration <- function(AccountId, Bucket, LifecycleConfiguration = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$put_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket, LifecycleConfiguration = LifecycleConfiguration)
  output <- .s3control$put_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_lifecycle_configuration <- s3control_put_bucket_lifecycle_configuration

#' This action puts a bucket policy to an Amazon S3 on Outposts bucket
#'
#' @description
#' This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see [`put_bucket_policy`][s3control_put_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_bucket_policy/](https://www.paws-r-sdk.com/docs/s3control_put_bucket_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param ConfirmRemoveSelfBucketAccess Set this parameter to true to confirm that you want to remove your
#' permissions to change this bucket policy in the future.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param Policy &#91;required&#93; The bucket policy as a JSON document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_policy
s3control_put_bucket_policy <- function(AccountId, Bucket, ConfirmRemoveSelfBucketAccess = NULL, Policy) {
  op <- new_operation(
    name = "PutBucketPolicy",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_bucket_policy_input(AccountId = AccountId, Bucket = Bucket, ConfirmRemoveSelfBucketAccess = ConfirmRemoveSelfBucketAccess, Policy = Policy)
  output <- .s3control$put_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_policy <- s3control_put_bucket_policy

#' This action creates an Amazon S3 on Outposts bucket's replication
#' configuration
#'
#' @description
#' This action creates an Amazon S3 on Outposts bucket's replication configuration. To create an S3 bucket's replication configuration, see [`put_bucket_replication`][s3control_put_bucket_replication] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_bucket_replication/](https://www.paws-r-sdk.com/docs/s3control_put_bucket_replication/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the S3 on Outposts bucket to set the configuration for.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param ReplicationConfiguration &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_replication
s3control_put_bucket_replication <- function(AccountId, Bucket, ReplicationConfiguration) {
  op <- new_operation(
    name = "PutBucketReplication",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/replication",
    paginator = list()
  )
  input <- .s3control$put_bucket_replication_input(AccountId = AccountId, Bucket = Bucket, ReplicationConfiguration = ReplicationConfiguration)
  output <- .s3control$put_bucket_replication_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_replication <- s3control_put_bucket_replication

#' This action puts tags on an Amazon S3 on Outposts bucket
#'
#' @description
#' This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see [`put_bucket_tagging`][s3control_put_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_bucket_tagging/](https://www.paws-r-sdk.com/docs/s3control_put_bucket_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The Amazon Resource Name (ARN) of the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through Outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param Tagging &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_tagging
s3control_put_bucket_tagging <- function(AccountId, Bucket, Tagging) {
  op <- new_operation(
    name = "PutBucketTagging",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$put_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket, Tagging = Tagging)
  output <- .s3control$put_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_tagging <- s3control_put_bucket_tagging

#' This operation sets the versioning state for S3 on Outposts buckets only
#'
#' @description
#' This operation sets the versioning state for S3 on Outposts buckets only. To set the versioning state for an S3 bucket, see [`put_bucket_versioning`][s3control_put_bucket_versioning] in the *Amazon S3 API Reference*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_bucket_versioning/](https://www.paws-r-sdk.com/docs/s3control_put_bucket_versioning/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the S3 on Outposts bucket.
#' @param Bucket &#91;required&#93; The S3 on Outposts bucket to set the versioning state for.
#' @param MFA The concatenation of the authentication device's serial number, a space,
#' and the value that is displayed on your authentication device.
#' @param VersioningConfiguration &#91;required&#93; The root-level tag for the `VersioningConfiguration` parameters.
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_versioning
s3control_put_bucket_versioning <- function(AccountId, Bucket, MFA = NULL, VersioningConfiguration) {
  op <- new_operation(
    name = "PutBucketVersioning",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/versioning",
    paginator = list()
  )
  input <- .s3control$put_bucket_versioning_input(AccountId = AccountId, Bucket = Bucket, MFA = MFA, VersioningConfiguration = VersioningConfiguration)
  output <- .s3control$put_bucket_versioning_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_versioning <- s3control_put_bucket_versioning

#' Sets the supplied tag-set on an S3 Batch Operations job
#'
#' @description
#' Sets the supplied tag-set on an S3 Batch Operations job.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_job_tagging/](https://www.paws-r-sdk.com/docs/s3control_put_job_tagging/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to replace.
#' @param Tags &#91;required&#93; The set of tags to associate with the S3 Batch Operations job.
#'
#' @keywords internal
#'
#' @rdname s3control_put_job_tagging
s3control_put_job_tagging <- function(AccountId, JobId, Tags) {
  op <- new_operation(
    name = "PutJobTagging",
    http_method = "PUT",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$put_job_tagging_input(AccountId = AccountId, JobId = JobId, Tags = Tags)
  output <- .s3control$put_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_job_tagging <- s3control_put_job_tagging

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_multi_region_access_point_policy/](https://www.paws-r-sdk.com/docs/s3control_put_multi_region_access_point_policy/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing the details of the policy for the
#' Multi-Region Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_put_multi_region_access_point_policy
s3control_put_multi_region_access_point_policy <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "PutMultiRegionAccessPointPolicy",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/put-policy",
    paginator = list()
  )
  input <- .s3control$put_multi_region_access_point_policy_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$put_multi_region_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_multi_region_access_point_policy <- s3control_put_multi_region_access_point_policy

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_public_access_block/](https://www.paws-r-sdk.com/docs/s3control_put_public_access_block/) for full documentation.
#'
#' @param PublicAccessBlockConfiguration &#91;required&#93; The `PublicAccessBlock` configuration that you want to apply to the
#' specified Amazon Web Services account.
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to set.
#'
#' @keywords internal
#'
#' @rdname s3control_put_public_access_block
s3control_put_public_access_block <- function(PublicAccessBlockConfiguration, AccountId) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$put_public_access_block_input(PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, AccountId = AccountId)
  output <- .s3control$put_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_public_access_block <- s3control_put_public_access_block

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_storage_lens_configuration/](https://www.paws-r-sdk.com/docs/s3control_put_storage_lens_configuration/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param StorageLensConfiguration &#91;required&#93; The S3 Storage Lens configuration.
#' @param Tags The tag set of the S3 Storage Lens configuration.
#' 
#' You can set up to a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname s3control_put_storage_lens_configuration
s3control_put_storage_lens_configuration <- function(ConfigId, AccountId, StorageLensConfiguration, Tags = NULL) {
  op <- new_operation(
    name = "PutStorageLensConfiguration",
    http_method = "PUT",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$put_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId, StorageLensConfiguration = StorageLensConfiguration, Tags = Tags)
  output <- .s3control$put_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_storage_lens_configuration <- s3control_put_storage_lens_configuration

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_put_storage_lens_configuration_tagging/](https://www.paws-r-sdk.com/docs/s3control_put_storage_lens_configuration_tagging/) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param Tags &#91;required&#93; The tag set of the S3 Storage Lens configuration.
#' 
#' You can set up to a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname s3control_put_storage_lens_configuration_tagging
s3control_put_storage_lens_configuration_tagging <- function(ConfigId, AccountId, Tags) {
  op <- new_operation(
    name = "PutStorageLensConfigurationTagging",
    http_method = "PUT",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$put_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId, Tags = Tags)
  output <- .s3control$put_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_storage_lens_configuration_tagging <- s3control_put_storage_lens_configuration_tagging

#' This operation is not supported by directory buckets
#'
#' @description
#' This operation is not supported by directory buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_submit_multi_region_access_point_routes/](https://www.paws-r-sdk.com/docs/s3control_submit_multi_region_access_point_routes/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Mrap &#91;required&#93; The Multi-Region Access Point ARN.
#' @param RouteUpdates &#91;required&#93; The different routes that make up the new route configuration. Active
#' routes return a value of `100`, and passive routes return a value of
#' `0`.
#'
#' @keywords internal
#'
#' @rdname s3control_submit_multi_region_access_point_routes
s3control_submit_multi_region_access_point_routes <- function(AccountId, Mrap, RouteUpdates) {
  op <- new_operation(
    name = "SubmitMultiRegionAccessPointRoutes",
    http_method = "PATCH",
    http_path = "/v20180820/mrap/instances/{mrap+}/routes",
    paginator = list()
  )
  input <- .s3control$submit_multi_region_access_point_routes_input(AccountId = AccountId, Mrap = Mrap, RouteUpdates = RouteUpdates)
  output <- .s3control$submit_multi_region_access_point_routes_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$submit_multi_region_access_point_routes <- s3control_submit_multi_region_access_point_routes

#' Creates a new Amazon Web Services resource tag or updates an existing
#' resource tag
#'
#' @description
#' Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_tag_resource/](https://www.paws-r-sdk.com/docs/s3control_tag_resource/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that created the S3 resource that
#' you're trying to add tags to or the requester's account ID.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 resource that you're trying to
#' add tags to. The tagged resource can be an S3 Storage Lens group or S3
#' Access Grants instance, registered location, or grant.
#' @param Tags &#91;required&#93; The Amazon Web Services resource tags that you want to add to the
#' specified S3 resource.
#'
#' @keywords internal
#'
#' @rdname s3control_tag_resource
s3control_tag_resource <- function(AccountId, ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v20180820/tags/{resourceArn+}",
    paginator = list()
  )
  input <- .s3control$tag_resource_input(AccountId = AccountId, ResourceArn = ResourceArn, Tags = Tags)
  output <- .s3control$tag_resource_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$tag_resource <- s3control_tag_resource

#' This operation removes the specified Amazon Web Services resource tags
#' from an S3 resource
#'
#' @description
#' This operation removes the specified Amazon Web Services resource tags from an S3 resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_untag_resource/](https://www.paws-r-sdk.com/docs/s3control_untag_resource/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that owns the resource that you're
#' trying to remove the tags from.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 resource that you're trying to
#' remove the tags from.
#' @param TagKeys &#91;required&#93; The array of tag key-value pairs that you're trying to remove from of
#' the S3 resource.
#'
#' @keywords internal
#'
#' @rdname s3control_untag_resource
s3control_untag_resource <- function(AccountId, ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v20180820/tags/{resourceArn+}",
    paginator = list()
  )
  input <- .s3control$untag_resource_input(AccountId = AccountId, ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .s3control$untag_resource_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$untag_resource <- s3control_untag_resource

#' Updates the IAM role of a registered location in your S3 Access Grants
#' instance
#'
#' @description
#' Updates the IAM role of a registered location in your S3 Access Grants instance.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_update_access_grants_location/](https://www.paws-r-sdk.com/docs/s3control_update_access_grants_location/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The ID of the Amazon Web Services account that is making this request.
#' @param AccessGrantsLocationId &#91;required&#93; The ID of the registered location that you are updating. S3 Access
#' Grants assigns this ID when you register the location. S3 Access Grants
#' assigns the ID `default` to the default location `s3://` and assigns an
#' auto-generated ID to other locations that you register.
#' 
#' The ID of the registered location to which you are granting access. S3
#' Access Grants assigned this ID when you registered the location. S3
#' Access Grants assigns the ID `default` to the default location `s3://`
#' and assigns an auto-generated ID to other locations that you register.
#' 
#' If you are passing the `default` location, you cannot create an access
#' grant for the entire default location. You must also specify a bucket or
#' a bucket and prefix in the `Subprefix` field.
#' @param IAMRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role for the registered
#' location. S3 Access Grants assumes this role to manage access to the
#' registered location.
#'
#' @keywords internal
#'
#' @rdname s3control_update_access_grants_location
s3control_update_access_grants_location <- function(AccountId, AccessGrantsLocationId, IAMRoleArn) {
  op <- new_operation(
    name = "UpdateAccessGrantsLocation",
    http_method = "PUT",
    http_path = "/v20180820/accessgrantsinstance/location/{id}",
    paginator = list()
  )
  input <- .s3control$update_access_grants_location_input(AccountId = AccountId, AccessGrantsLocationId = AccessGrantsLocationId, IAMRoleArn = IAMRoleArn)
  output <- .s3control$update_access_grants_location_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_access_grants_location <- s3control_update_access_grants_location

#' Updates an existing S3 Batch Operations job's priority
#'
#' @description
#' Updates an existing S3 Batch Operations job's priority. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_update_job_priority/](https://www.paws-r-sdk.com/docs/s3control_update_job_priority/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the job whose priority you want to update.
#' @param Priority &#91;required&#93; The priority you want to assign to this job.
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_priority
s3control_update_job_priority <- function(AccountId, JobId, Priority) {
  op <- new_operation(
    name = "UpdateJobPriority",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/priority",
    paginator = list()
  )
  input <- .s3control$update_job_priority_input(AccountId = AccountId, JobId = JobId, Priority = Priority)
  output <- .s3control$update_job_priority_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_priority <- s3control_update_job_priority

#' Updates the status for the specified job
#'
#' @description
#' Updates the status for the specified job. Use this operation to confirm that you want to run a job or to cancel an existing job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_update_job_status/](https://www.paws-r-sdk.com/docs/s3control_update_job_status/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID of the job whose status you want to update.
#' @param RequestedJobStatus &#91;required&#93; The status that you want to move the specified job to.
#' @param StatusUpdateReason A description of the reason why you want to change the specified job's
#' status. This field can be any string up to the maximum length.
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_status
s3control_update_job_status <- function(AccountId, JobId, RequestedJobStatus, StatusUpdateReason = NULL) {
  op <- new_operation(
    name = "UpdateJobStatus",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/status",
    paginator = list()
  )
  input <- .s3control$update_job_status_input(AccountId = AccountId, JobId = JobId, RequestedJobStatus = RequestedJobStatus, StatusUpdateReason = StatusUpdateReason)
  output <- .s3control$update_job_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_status <- s3control_update_job_status

#' Updates the existing Storage Lens group
#'
#' @description
#' Updates the existing Storage Lens group.
#'
#' See [https://www.paws-r-sdk.com/docs/s3control_update_storage_lens_group/](https://www.paws-r-sdk.com/docs/s3control_update_storage_lens_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Storage Lens group that you want to update.
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Storage Lens group owner.
#' @param StorageLensGroup &#91;required&#93; The JSON file that contains the Storage Lens group configuration.
#'
#' @keywords internal
#'
#' @rdname s3control_update_storage_lens_group
s3control_update_storage_lens_group <- function(Name, AccountId, StorageLensGroup) {
  op <- new_operation(
    name = "UpdateStorageLensGroup",
    http_method = "PUT",
    http_path = "/v20180820/storagelensgroup/{name}",
    paginator = list()
  )
  input <- .s3control$update_storage_lens_group_input(Name = Name, AccountId = AccountId, StorageLensGroup = StorageLensGroup)
  output <- .s3control$update_storage_lens_group_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_storage_lens_group <- s3control_update_storage_lens_group
