% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_put_account_preferences}
\alias{efs_put_account_preferences}
\title{Use this operation to set the account preference in the current Amazon
Web Services Region to use long 17 character (63 bit) or short 8
character (32 bit) resource IDs for new EFS file system and mount target
resources}
\usage{
efs_put_account_preferences(ResourceIdType)
}
\arguments{
\item{ResourceIdType}{[required] Specifies the EFS resource ID preference to set for the user's Amazon
Web Services account, in the current Amazon Web Services Region, either
\code{LONG_ID} (17 characters), or \code{SHORT_ID} (8 characters).

Starting in October, 2021, you will receive an error when setting the
account preference to \code{SHORT_ID}. Contact Amazon Web Services support if
you receive an error and must use short IDs for file system and mount
target resources.}
}
\description{
Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the opt-in period as EFS transitions to long resource IDs. For more information, see \href{https://docs.aws.amazon.com/efs/latest/ug/}{Managing Amazon EFS resource IDs}.

See \url{https://www.paws-r-sdk.com/docs/efs_put_account_preferences/} for full documentation.
}
\keyword{internal}
