% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm_operations.R
\name{dlm_update_lifecycle_policy}
\alias{dlm_update_lifecycle_policy}
\title{Updates the specified lifecycle policy}
\usage{
dlm_update_lifecycle_policy(PolicyId, ExecutionRoleArn, State,
  Description, PolicyDetails)
}
\arguments{
\item{PolicyId}{[required] The identifier of the lifecycle policy.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the IAM role used to run the
operations specified by the lifecycle policy.}

\item{State}{The desired activation state of the lifecycle policy after creation.}

\item{Description}{A description of the lifecycle policy.}

\item{PolicyDetails}{The configuration of the lifecycle policy. You cannot update the policy
type or the resource type.}
}
\description{
Updates the specified lifecycle policy.
}
\section{Request syntax}{
\preformatted{svc$update_lifecycle_policy(
  PolicyId = "string",
  ExecutionRoleArn = "string",
  State = "ENABLED"|"DISABLED",
  Description = "string",
  PolicyDetails = list(
    PolicyType = "EBS_SNAPSHOT_MANAGEMENT",
    ResourceTypes = list(
      "VOLUME"|"INSTANCE"
    ),
    TargetTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    Schedules = list(
      list(
        Name = "string",
        CopyTags = TRUE|FALSE,
        TagsToAdd = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        VariableTags = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        CreateRule = list(
          Interval = 123,
          IntervalUnit = "HOURS",
          Times = list(
            "string"
          )
        ),
        RetainRule = list(
          Count = 123,
          Interval = 123,
          IntervalUnit = "DAYS"|"WEEKS"|"MONTHS"|"YEARS"
        ),
        FastRestoreRule = list(
          Count = 123,
          Interval = 123,
          IntervalUnit = "DAYS"|"WEEKS"|"MONTHS"|"YEARS",
          AvailabilityZones = list(
            "string"
          )
        ),
        CrossRegionCopyRules = list(
          list(
            TargetRegion = "string",
            Encrypted = TRUE|FALSE,
            CmkArn = "string",
            CopyTags = TRUE|FALSE,
            RetainRule = list(
              Interval = 123,
              IntervalUnit = "DAYS"|"WEEKS"|"MONTHS"|"YEARS"
            )
          )
        )
      )
    ),
    Parameters = list(
      ExcludeBootVolume = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
