% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_retrieve_tape_archive}
\alias{storagegateway_retrieve_tape_archive}
\title{Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
a tape gateway}
\usage{
storagegateway_retrieve_tape_archive(TapeARN, GatewayARN)
}
\arguments{
\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape you want to retrieve
from the virtual tape shelf (VTS).}

\item{GatewayARN}{[required] The Amazon Resource Name (ARN) of the gateway you want to retrieve the
virtual tape to. Use the ListGateways operation to return a list of
gateways for your account and AWS Region.

You retrieve archived virtual tapes to only one gateway and the gateway
must be a tape gateway.}
}
\description{
Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
a tape gateway. Virtual tapes archived in the VTS are not associated
with any gateway. However after a tape is retrieved, it is associated
with a gateway, even though it is also listed in the VTS, that is,
archive. This operation is only supported in the tape gateway type.
}
\details{
Once a tape is successfully retrieved to a gateway, it cannot be
retrieved again to another gateway. You must archive the tape again
before you can retrieve it to another gateway. This operation is only
supported in the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$retrieve_tape_archive(
  TapeARN = "string",
  GatewayARN = "string"
)
}
}

\examples{
# Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
# a gateway-VTL. Virtual tapes archived in the VTS are not associated with
# any gateway.
\dontrun{svc$retrieve_tape_archive(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"
)}

}
\keyword{internal}
