% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_tagging}
\alias{s3_put_bucket_tagging}
\title{Sets the tags for a bucket}
\usage{
s3_put_bucket_tagging(Bucket, ContentMD5, Tagging)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{Tagging}{[required]}
}
\description{
Sets the tags for a bucket.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_tagging(
  Bucket = "string",
  ContentMD5 = "string",
  Tagging = list(
    TagSet = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}

\examples{
# The following example sets tags on a bucket. Any existing tags are
# replaced.
\donttest{svc$put_bucket_tagging(
  Bucket = "examplebucket",
  Tagging = list(
    TagSet = list(
      list(
        Key = "Key1",
        Value = "Value1"
      ),
      list(
        Key = "Key2",
        Value = "Value2"
      )
    )
  )
)}

}
\keyword{internal}
