% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_notify_when_uploaded}
\alias{storagegateway_notify_when_uploaded}
\title{Sends you notification through CloudWatch Events when all files written
to your NFS file share have been uploaded to Amazon S3}
\usage{
storagegateway_notify_when_uploaded(FileShareARN)
}
\arguments{
\item{FileShareARN}{[required]}
}
\description{
Sends you notification through CloudWatch Events when all files written
to your NFS file share have been uploaded to Amazon S3.
}
\details{
AWS Storage Gateway can send a notification through Amazon CloudWatch
Events when all files written to your file share up to that point in
time have been uploaded to Amazon S3. These files include files written
to the NFS file share up to the time that you make a request for
notification. When the upload is done, Storage Gateway sends you
notification through an Amazon CloudWatch Event. You can configure
CloudWatch Events to send the notification through event targets such as
Amazon SNS or AWS Lambda function. This operation is only supported for
file gateways.

For more information, see Getting File Upload Notification in the
Storage Gateway User Guide
(https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html\#get-upload-notification).
}
\section{Request syntax}{
\preformatted{svc$notify_when_uploaded(
  FileShareARN = "string"
)
}
}

\keyword{internal}
