% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_vtl_devices}
\alias{storagegateway_describe_vtl_devices}
\title{Returns a description of virtual tape library (VTL) devices for the
specified tape gateway}
\usage{
storagegateway_describe_vtl_devices(GatewayARN, VTLDeviceARNs, Marker,
  Limit)
}
\arguments{
\item{GatewayARN}{[required]}

\item{VTLDeviceARNs}{An array of strings, where each string represents the Amazon Resource
Name (ARN) of a VTL device.

All of the specified VTL devices must be from the same gateway. If no
VTL devices are specified, the result will contain all devices on the
specified gateway.}

\item{Marker}{An opaque string that indicates the position at which to begin
describing the VTL devices.}

\item{Limit}{Specifies that the number of VTL devices described be limited to the
specified number.}
}
\value{
A list with the following syntax:\preformatted{list(
  GatewayARN = "string",
  VTLDevices = list(
    list(
      VTLDeviceARN = "string",
      VTLDeviceType = "string",
      VTLDeviceVendor = "string",
      VTLDeviceProductIdentifier = "string",
      DeviceiSCSIAttributes = list(
        TargetARN = "string",
        NetworkInterfaceId = "string",
        NetworkInterfacePort = 123,
        ChapEnabled = TRUE|FALSE
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Returns a description of virtual tape library (VTL) devices for the
specified tape gateway. In the response, AWS Storage Gateway returns VTL
device information.

This operation is only supported in the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$describe_vtl_devices(
  GatewayARN = "string",
  VTLDeviceARNs = list(
    "string"
  ),
  Marker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# Returns a description of virtual tape library (VTL) devices for the
# specified gateway.
svc$describe_vtl_devices(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
  Limit = 123L,
  Marker = "1",
  VTLDeviceARNs = list()
)
}

}
\keyword{internal}
