% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_select_object_content}
\alias{s3_select_object_content}
\title{This operation filters the contents of an Amazon S3 object based on a
simple structured query language (SQL) statement}
\usage{
s3_select_object_content(Bucket, Key, SSECustomerAlgorithm,
  SSECustomerKey, SSECustomerKeyMD5, Expression, ExpressionType,
  RequestProgress, InputSerialization, OutputSerialization, ScanRange,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The S3 bucket.}

\item{Key}{[required] The object key.}

\item{SSECustomerAlgorithm}{The SSE Algorithm used to encrypt the object. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{SSECustomerKey}{The SSE Customer Key. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{SSECustomerKeyMD5}{The SSE Customer Key MD5. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{Expression}{[required] The expression that is used to query the object.}

\item{ExpressionType}{[required] The type of the provided expression (for example, SQL).}

\item{RequestProgress}{Specifies if periodic request progress information should be enabled.}

\item{InputSerialization}{[required] Describes the format of the data in the object that is being queried.}

\item{OutputSerialization}{[required] Describes the format of the data that you want Amazon S3 to return in
response.}

\item{ScanRange}{Specifies the byte range of the object to get the records from. A record
is processed when its first byte is contained by the range. This
parameter is optional, but when specified, it must not be empty. See RFC
2616, Section 14.35.1 about how to specify the start and end of the
range.

\code{ScanRange}may be used in the following ways:
\itemize{
\item \verb{<scanrange><start>50</start><end>100</end></scanrange>} - process
only the records starting between the bytes 50 and 100 (inclusive,
counting from zero)
\item \verb{<scanrange><start>50</start></scanrange>} - process only the
records starting after the byte 50
\item \verb{<scanrange><end>50</end></scanrange>} - process only the records
within the last 50 bytes of the file.
}}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  Payload = list(
    Records = list(
      Payload = raw
    ),
    Stats = list(
      Details = list(
        BytesScanned = 123,
        BytesProcessed = 123,
        BytesReturned = 123
      )
    ),
    Progress = list(
      Details = list(
        BytesScanned = 123,
        BytesProcessed = 123,
        BytesReturned = 123
      )
    ),
    Cont = list(),
    End = list()
  )
)
}
}
\description{
This operation filters the contents of an Amazon S3 object based on a
simple structured query language (SQL) statement. In the request, along
with the SQL expression, you must also specify a data serialization
format (JSON, CSV, or Apache Parquet) of the object. Amazon S3 uses this
format to parse object data into records, and returns only records that
match the specified SQL expression. You must also specify the data
serialization format for the response.

This action is not supported by Amazon S3 on Outposts.

For more information about Amazon S3 Select, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/selecting-content-from-objects.html}{Selecting Content from Objects}
in the \emph{Amazon Simple Storage Service Developer Guide}.

For more information about using SQL with Amazon S3 Select, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-glacier-select-sql-reference.html}{SQL Reference for Amazon S3 Select and S3 Glacier Select}
in the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Permissions}

You must have \code{s3:GetObject} permission for this operation. Amazon S3
Select does not support anonymous access. For more information about
permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html}{Specifying Permissions in a Policy}
in the \emph{Amazon Simple Storage Service Developer Guide}.

\emph{Object Data Formats}

You can use Amazon S3 Select to query objects that have the following
format properties:
\itemize{
\item \emph{CSV, JSON, and Parquet} - Objects must be in CSV, JSON, or Parquet
format.
\item \emph{UTF-8} - UTF-8 is the only encoding type Amazon S3 Select supports.
\item \emph{GZIP or BZIP2} - CSV and JSON files can be compressed using GZIP or
BZIP2. GZIP and BZIP2 are the only compression formats that Amazon
S3 Select supports for CSV and JSON files. Amazon S3 Select supports
columnar compression for Parquet using GZIP or Snappy. Amazon S3
Select does not support whole-object compression for Parquet
objects.
\item \emph{Server-side encryption} - Amazon S3 Select supports querying
objects that are protected with server-side encryption.

For objects that are encrypted with customer-provided encryption
keys (SSE-C), you must use HTTPS, and you must use the headers that
are documented in the \code{\link[=s3_get_object]{get_object}}. For more
information about SSE-C, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys)}
in the \emph{Amazon Simple Storage Service Developer Guide}.

For objects that are encrypted with Amazon S3 managed encryption
keys (SSE-S3) and customer master keys (CMKs) stored in AWS Key
Management Service (SSE-KMS), server-side encryption is handled
transparently, so you don't need to specify anything. For more
information about server-side encryption, including SSE-S3 and
SSE-KMS, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/serv-side-encryption.html}{Protecting Data Using Server-Side Encryption}
in the \emph{Amazon Simple Storage Service Developer Guide}.
}

\strong{Working with the Response Body}

Given the response size is unknown, Amazon S3 Select streams the
response as a series of messages and includes a \code{Transfer-Encoding}
header with \code{chunked} as its value in the response. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/RESTSelectObjectAppendix.html}{Appendix: SelectObjectContent Response}
.

\strong{GetObject Support}

The \code{\link[=s3_select_object_content]{select_object_content}} operation does
not support the following \code{\link[=s3_get_object]{get_object}} functionality.
For more information, see \code{\link[=s3_get_object]{get_object}}.
\itemize{
\item \code{Range}: Although you can specify a scan range for an Amazon S3
Select request (see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_SelectObjectContent.html#AmazonS3-SelectObjectContent-request-ScanRange}{SelectObjectContentRequest - ScanRange}
in the request parameters), you cannot specify the range of bytes of
an object to return.
\item GLACIER, DEEP_ARCHIVE and REDUCED_REDUNDANCY storage classes: You
cannot specify the GLACIER, DEEP_ARCHIVE, or \code{REDUCED_REDUNDANCY}
storage classes. For more information, about storage classes see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#storage-class-intro}{Storage Classes}
in the \emph{Amazon Simple Storage Service Developer Guide}.
}

\strong{Special Errors}

For a list of special errors for this operation, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#SelectObjectContentErrorCodeList}{List of SELECT Object Content Error Codes}

\strong{Related Resources}
\itemize{
\item \code{\link[=s3_get_object]{get_object}}
\item \code{\link[=s3_get_bucket_lifecycle_configuration]{get_bucket_lifecycle_configuration}}
\item \code{\link[=s3_put_bucket_lifecycle_configuration]{put_bucket_lifecycle_configuration}}
}
}
\section{Request syntax}{
\preformatted{svc$select_object_content(
  Bucket = "string",
  Key = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  Expression = "string",
  ExpressionType = "SQL",
  RequestProgress = list(
    Enabled = TRUE|FALSE
  ),
  InputSerialization = list(
    CSV = list(
      FileHeaderInfo = "USE"|"IGNORE"|"NONE",
      Comments = "string",
      QuoteEscapeCharacter = "string",
      RecordDelimiter = "string",
      FieldDelimiter = "string",
      QuoteCharacter = "string",
      AllowQuotedRecordDelimiter = TRUE|FALSE
    ),
    CompressionType = "NONE"|"GZIP"|"BZIP2",
    JSON = list(
      Type = "DOCUMENT"|"LINES"
    ),
    Parquet = list()
  ),
  OutputSerialization = list(
    CSV = list(
      QuoteFields = "ALWAYS"|"ASNEEDED",
      QuoteEscapeCharacter = "string",
      RecordDelimiter = "string",
      FieldDelimiter = "string",
      QuoteCharacter = "string"
    ),
    JSON = list(
      RecordDelimiter = "string"
    )
  ),
  ScanRange = list(
    Start = 123,
    End = 123
  ),
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
