% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_lifecycle_configuration}
\alias{s3_put_bucket_lifecycle_configuration}
\title{Sets lifecycle configuration for your bucket}
\usage{
s3_put_bucket_lifecycle_configuration(Bucket, LifecycleConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{LifecycleConfiguration}{}
}
\description{
Sets lifecycle configuration for your bucket. If a lifecycle
configuration exists, it replaces it.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_lifecycle_configuration(
  Bucket = "string",
  LifecycleConfiguration = list(
    Rules = list(
      list(
        Expiration = list(
          Date = as.POSIXct(
            "2015-01-01"
          ),
          Days = 123,
          ExpiredObjectDeleteMarker = TRUE|FALSE
        ),
        ID = "string",
        Prefix = "string",
        Filter = list(
          Prefix = "string",
          Tag = list(
            Key = "string",
            Value = "string"
          ),
          And = list(
            Prefix = "string",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        ),
        Status = "Enabled"|"Disabled",
        Transitions = list(
          list(
            Date = as.POSIXct(
              "2015-01-01"
            ),
            Days = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionTransitions = list(
          list(
            NoncurrentDays = 123,
            StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
          )
        ),
        NoncurrentVersionExpiration = list(
          NoncurrentDays = 123
        ),
        AbortIncompleteMultipartUpload = list(
          DaysAfterInitiation = 123
        )
      )
    )
  )
)
}
}

\examples{
# The following example replaces existing lifecycle configuration, if any,
# on the specified bucket.
\donttest{svc$put_bucket_lifecycle_configuration(
  Bucket = "examplebucket",
  LifecycleConfiguration = list(
    Rules = list(
      list(
        Expiration = list(
          Days = 3650L
        ),
        Filter = list(
          Prefix = "documents/"
        ),
        ID = "TestOnly",
        Status = "Enabled",
        Transitions = list(
          list(
            Days = 365L,
            StorageClass = "GLACIER"
          )
        )
      )
    )
  )
)}

}
\keyword{internal}
