% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_permission_versions}
\alias{ram_list_permission_versions}
\title{Lists the available versions of the specified RAM permission}
\usage{
ram_list_permission_versions(
  permissionArn,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{permissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the RAM permission whose versions you want to list. You can use the
\code{permissionVersion} parameter on the
\code{\link[=ram_associate_resource_share_permission]{associate_resource_share_permission}}
operation to specify a non-default version to attach.}

\item{nextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}

\item{maxResults}{Specifies the total number of results that you want included on each
page of the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the number you specify, the \code{NextToken} response element is
returned with a value (not null). Include the specified value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that the service might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists the available versions of the specified RAM permission.

See \url{https://www.paws-r-sdk.com/docs/ram_list_permission_versions/} for full documentation.
}
\keyword{internal}
