% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_delete_permission_version}
\alias{ram_delete_permission_version}
\title{Deletes one version of a customer managed permission}
\usage{
ram_delete_permission_version(
  permissionArn,
  permissionVersion,
  clientToken = NULL
)
}
\arguments{
\item{permissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the permission with the version you want to delete.}

\item{permissionVersion}{[required] Specifies the version number to delete.

You can't delete the default version for a customer managed permission.

You can't delete a version if it's the only version of the permission.
You must either first create another version, or delete the permission
completely.

You can't delete a version if it is attached to any resource shares. If
the version is the default, you must first use
\code{\link[=ram_set_default_permission_version]{set_default_permission_version}}
to set a different version as the default for the customer managed
permission, and then use
\code{\link[=ram_associate_resource_share_permission]{associate_resource_share_permission}}
to update your resource shares to use the new default version.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
Deletes one version of a customer managed permission. The version you specify must not be attached to any resource share and must not be the default version for the permission.

See \url{https://www.paws-r-sdk.com/docs/ram_delete_permission_version/} for full documentation.
}
\keyword{internal}
