% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_get_device}
\alias{cognitoidentityprovider_admin_get_device}
\title{Given the device key, returns details for a user' device}
\usage{
cognitoidentityprovider_admin_get_device(DeviceKey, UserPoolId, Username)
}
\arguments{
\item{DeviceKey}{[required] The key of the device that you want to delete. You can get device IDs in
the response to an
\code{\link[=cognitoidentityprovider_admin_list_devices]{admin_list_devices}}
request.}

\item{UserPoolId}{[required] The ID of the user pool where the device owner is a user.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}
}
\description{
Given the device key, returns details for a user' device. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html}{Working with devices}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_get_device/} for full documentation.
}
\keyword{internal}
