% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_service.R
\name{verifiedpermissions}
\alias{verifiedpermissions}
\title{Amazon Verified Permissions}
\usage{
verifiedpermissions(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Verified Permissions is a permissions management service from
Amazon Web Services. You can use Verified Permissions to manage
permissions for your application, and authorize user access based on
those permissions. Using Verified Permissions, application developers
can grant access based on information about the users, resources, and
requested actions. You can also evaluate additional information like
group membership, attributes of the resources, and session context, such
as time of request and IP addresses. Verified Permissions manages these
permissions by letting you create and store authorization policies for
your applications, such as consumer-facing web sites and enterprise
business systems.

Verified Permissions uses Cedar as the policy language to express your
permission requirements. Cedar supports both role-based access control
(RBAC) and attribute-based access control (ABAC) authorization models.

For more information about configuring, administering, and using Amazon
Verified Permissions in your applications, see the \href{https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/}{Amazon Verified Permissions User Guide}.

For more information about the Cedar policy language, see the \href{https://docs.cedarpolicy.com/}{Cedar Policy Language Guide}.

When you write Cedar policies that reference principals, resources and
actions, you can define the unique identifiers used for each of those
elements. We strongly recommend that you follow these best practices:
\itemize{
\item \strong{Use values like universally unique identifiers (UUIDs) for all
principal and resource identifiers.}

For example, if user \code{jane} leaves the company, and you later let
someone else use the name \code{jane}, then that new user automatically
gets access to everything granted by policies that still reference
\code{User::"jane"}. Cedar can’t distinguish between the new user and the
old. This applies to both principal and resource identifiers. Always
use identifiers that are guaranteed unique and never reused to
ensure that you don’t unintentionally grant access because of the
presence of an old identifier in a policy.

Where you use a UUID for an entity, we recommend that you follow it
with the // comment specifier and the ‘friendly’ name of your
entity. This helps to make your policies easier to understand. For
example: principal == User::"a1b2c3d4-e5f6-a1b2-c3d4-EXAMPLE11111",
// alice
\item \strong{Do not include personally identifying, confidential, or sensitive
information as part of the unique identifier for your principals or
resources.} These identifiers are included in log entries shared in
CloudTrail trails.
}

Several operations return structures that appear similar, but have
different purposes. As new functionality is added to the product, the
structure used in a parameter of one operation might need to change in a
way that wouldn't make sense for the same parameter in a different
operation. To help you understand the purpose of each, the following
naming convention is used for the structures:
\itemize{
\item Parameter type structures that end in \code{Detail} are used in \code{Get}
operations.
\item Parameter type structures that end in \code{Item} are used in \code{List}
operations.
\item Parameter type structures that use neither suffix are used in the
mutating (create and update) operations.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- verifiedpermissions(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=verifiedpermissions_batch_is_authorized]{batch_is_authorized} \tab Makes a series of decisions about multiple authorization requests for one principal or resource\cr
\link[=verifiedpermissions_batch_is_authorized_with_token]{batch_is_authorized_with_token} \tab Makes a series of decisions about multiple authorization requests for one token\cr
\link[=verifiedpermissions_create_identity_source]{create_identity_source} \tab Creates a reference to an Amazon Cognito user pool as an external identity provider (IdP)\cr
\link[=verifiedpermissions_create_policy]{create_policy} \tab Creates a Cedar policy and saves it in the specified policy store\cr
\link[=verifiedpermissions_create_policy_store]{create_policy_store} \tab Creates a policy store\cr
\link[=verifiedpermissions_create_policy_template]{create_policy_template} \tab Creates a policy template\cr
\link[=verifiedpermissions_delete_identity_source]{delete_identity_source} \tab Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito\cr
\link[=verifiedpermissions_delete_policy]{delete_policy} \tab Deletes the specified policy from the policy store\cr
\link[=verifiedpermissions_delete_policy_store]{delete_policy_store} \tab Deletes the specified policy store\cr
\link[=verifiedpermissions_delete_policy_template]{delete_policy_template} \tab Deletes the specified policy template from the policy store\cr
\link[=verifiedpermissions_get_identity_source]{get_identity_source} \tab Retrieves the details about the specified identity source\cr
\link[=verifiedpermissions_get_policy]{get_policy} \tab Retrieves information about the specified policy\cr
\link[=verifiedpermissions_get_policy_store]{get_policy_store} \tab Retrieves details about a policy store\cr
\link[=verifiedpermissions_get_policy_template]{get_policy_template} \tab Retrieve the details for the specified policy template in the specified policy store\cr
\link[=verifiedpermissions_get_schema]{get_schema} \tab Retrieve the details for the specified schema in the specified policy store\cr
\link[=verifiedpermissions_is_authorized]{is_authorized} \tab Makes an authorization decision about a service request described in the parameters\cr
\link[=verifiedpermissions_is_authorized_with_token]{is_authorized_with_token} \tab Makes an authorization decision about a service request described in the parameters\cr
\link[=verifiedpermissions_list_identity_sources]{list_identity_sources} \tab Returns a paginated list of all of the identity sources defined in the specified policy store\cr
\link[=verifiedpermissions_list_policies]{list_policies} \tab Returns a paginated list of all policies stored in the specified policy store\cr
\link[=verifiedpermissions_list_policy_stores]{list_policy_stores} \tab Returns a paginated list of all policy stores in the calling Amazon Web Services account\cr
\link[=verifiedpermissions_list_policy_templates]{list_policy_templates} \tab Returns a paginated list of all policy templates in the specified policy store\cr
\link[=verifiedpermissions_put_schema]{put_schema} \tab Creates or updates the policy schema in the specified policy store\cr
\link[=verifiedpermissions_update_identity_source]{update_identity_source} \tab Updates the specified identity source to use a new identity provider (IdP) source, or to change the mapping of identities from the IdP to a different principal entity type\cr
\link[=verifiedpermissions_update_policy]{update_policy} \tab Modifies a Cedar static policy in the specified policy store\cr
\link[=verifiedpermissions_update_policy_store]{update_policy_store} \tab Modifies the validation setting for a policy store\cr
\link[=verifiedpermissions_update_policy_template]{update_policy_template} \tab Updates the specified policy template
}
}

\examples{
\dontrun{
svc <- verifiedpermissions()
svc$batch_is_authorized(
  Foo = 123
)
}

}
