# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include acmpca_service.R
NULL

#' Creates a root or subordinate private certificate authority (CA)
#'
#' @description
#' Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_create_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_create_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityConfiguration &#91;required&#93; Name and bit size of the private key algorithm, the name of the signing
#' algorithm, and X.500 certificate subject information.
#' @param RevocationConfiguration Contains information to enable Online Certificate Status Protocol (OCSP)
#' support, to enable a certificate revocation list (CRL), to enable both,
#' or to enable neither. The default is for both certificate validation
#' mechanisms to be disabled.
#' 
#' The following requirements apply to revocation configurations.
#' 
#' -   A configuration disabling CRLs or OCSP must contain only the
#'     `Enabled=False` parameter, and will fail if other parameters such as
#'     `CustomCname` or `ExpirationInDays` are included.
#' 
#' -   In a CRL configuration, the `S3BucketName` parameter must conform to
#'     [Amazon S3 bucket naming
#'     rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
#' 
#' -   A configuration containing a custom Canonical Name (CNAME) parameter
#'     for CRLs or OCSP must conform to
#'     [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the
#'     use of special characters in a CNAME.
#' 
#' -   In a CRL or OCSP configuration, the value of a CNAME parameter must
#'     not include a protocol prefix such as "http://" or "https://".
#' 
#' For more information, see the
#' [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html)
#' and
#' [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html)
#' types.
#' @param CertificateAuthorityType &#91;required&#93; The type of the certificate authority.
#' @param IdempotencyToken Custom string that can be used to distinguish between calls to the
#' **CreateCertificateAuthority** action. Idempotency tokens for
#' **CreateCertificateAuthority** time out after five minutes. Therefore,
#' if you call **CreateCertificateAuthority** multiple times with the same
#' idempotency token within five minutes, Amazon Web Services Private CA
#' recognizes that you are requesting only certificate authority and will
#' issue only one. If you change the idempotency token for each call,
#' Amazon Web Services Private CA recognizes that you are requesting
#' multiple certificate authorities.
#' @param KeyStorageSecurityStandard Specifies a cryptographic key management compliance standard used for
#' handling CA keys.
#' 
#' Default: FIPS_140_2_LEVEL_3_OR_HIGHER
#' 
#' Some Amazon Web Services Regions do not support the default. When
#' creating a CA in these Regions, you must provide
#' `FIPS_140_2_LEVEL_2_OR_HIGHER` as the argument for
#' `KeyStorageSecurityStandard`. Failure to do this results in an
#' `InvalidArgsException` with the message, "A certificate authority cannot
#' be created in this region with the specified security standard."
#' 
#' For information about security standard support in various Regions, see
#' [Storage and security compliance of Amazon Web Services Private CA
#' private
#' keys](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
#' @param Tags Key-value pairs that will be attached to the new private CA. You can
#' associate up to 50 tags with a private CA. For information using tags
#' with IAM to manage permissions, see [Controlling Access Using IAM
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
#' @param UsageMode Specifies whether the CA issues general-purpose certificates that
#' typically require a revocation mechanism, or short-lived certificates
#' that may optionally omit revocation because they expire quickly.
#' Short-lived certificate validity is limited to seven days.
#' 
#' The default value is GENERAL_PURPOSE.
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority
acmpca_create_certificate_authority <- function(CertificateAuthorityConfiguration, RevocationConfiguration = NULL, CertificateAuthorityType, IdempotencyToken = NULL, KeyStorageSecurityStandard = NULL, Tags = NULL, UsageMode = NULL) {
  op <- new_operation(
    name = "CreateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_input(CertificateAuthorityConfiguration = CertificateAuthorityConfiguration, RevocationConfiguration = RevocationConfiguration, CertificateAuthorityType = CertificateAuthorityType, IdempotencyToken = IdempotencyToken, KeyStorageSecurityStandard = KeyStorageSecurityStandard, Tags = Tags, UsageMode = UsageMode)
  output <- .acmpca$create_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority <- acmpca_create_certificate_authority

#' Creates an audit report that lists every time that your CA private key
#' is used
#'
#' @description
#' Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The [`issue_certificate`][acmpca_issue_certificate] and [`revoke_certificate`][acmpca_revoke_certificate] actions use the private key.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_create_certificate_authority_audit_report/](https://www.paws-r-sdk.com/docs/acmpca_create_certificate_authority_audit_report/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA to be audited. This is of the
#' form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param S3BucketName &#91;required&#93; The name of the S3 bucket that will contain the audit report.
#' @param AuditReportResponseFormat &#91;required&#93; The format in which to create the report. This can be either **JSON** or
#' **CSV**.
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority_audit_report
acmpca_create_certificate_authority_audit_report <- function(CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat) {
  op <- new_operation(
    name = "CreateCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, S3BucketName = S3BucketName, AuditReportResponseFormat = AuditReportResponseFormat)
  output <- .acmpca$create_certificate_authority_audit_report_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority_audit_report <- acmpca_create_certificate_authority_audit_report

#' Grants one or more permissions on a private CA to the Certificate
#' Manager (ACM) service principal (acm
#'
#' @description
#' Grants one or more permissions on a private CA to the Certificate Manager (ACM) service principal (`acm.amazonaws.com`). These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_create_permission/](https://www.paws-r-sdk.com/docs/acmpca_create_permission/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA that grants the permissions.
#' You can find the ARN by calling the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action. This must have the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param Principal &#91;required&#93; The Amazon Web Services service or identity that receives the
#' permission. At this time, the only valid principal is
#' `acm.amazonaws.com`.
#' @param SourceAccount The ID of the calling account.
#' @param Actions &#91;required&#93; The actions that the specified Amazon Web Services service principal can
#' use. These include [`issue_certificate`][acmpca_issue_certificate],
#' [`get_certificate`][acmpca_get_certificate], and
#' [`list_permissions`][acmpca_list_permissions].
#'
#' @keywords internal
#'
#' @rdname acmpca_create_permission
acmpca_create_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL, Actions) {
  op <- new_operation(
    name = "CreatePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount, Actions = Actions)
  output <- .acmpca$create_permission_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_permission <- acmpca_create_permission

#' Deletes a private certificate authority (CA)
#'
#' @description
#' Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the [`list_certificate_authorities`][acmpca_list_certificate_authorities] action.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_delete_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_delete_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must have the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param PermanentDeletionTimeInDays The number of days to make a CA restorable after it has been deleted.
#' This can be anywhere from 7 to 30 days, with 30 being the default.
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_certificate_authority
acmpca_delete_certificate_authority <- function(CertificateAuthorityArn, PermanentDeletionTimeInDays = NULL) {
  op <- new_operation(
    name = "DeleteCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, PermanentDeletionTimeInDays = PermanentDeletionTimeInDays)
  output <- .acmpca$delete_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_certificate_authority <- acmpca_delete_certificate_authority

#' Revokes permissions on a private CA granted to the Certificate Manager
#' (ACM) service principal (acm
#'
#' @description
#' Revokes permissions on a private CA granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_delete_permission/](https://www.paws-r-sdk.com/docs/acmpca_delete_permission/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that issued the
#' permissions. You can find the CA's ARN by calling the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action. This must have the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param Principal &#91;required&#93; The Amazon Web Services service or identity that will have its CA
#' permissions revoked. At this time, the only valid service principal is
#' `acm.amazonaws.com`
#' @param SourceAccount The Amazon Web Services account that calls this action.
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_permission
acmpca_delete_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL) {
  op <- new_operation(
    name = "DeletePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount)
  output <- .acmpca$delete_permission_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_permission <- acmpca_delete_permission

#' Deletes the resource-based policy attached to a private CA
#'
#' @description
#' Deletes the resource-based policy attached to a private CA. Deletion will remove any access that the policy has granted. If there is no policy attached to the private CA, this action will return successful.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_delete_policy/](https://www.paws-r-sdk.com/docs/acmpca_delete_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that will have its
#' policy deleted. You can find the CA's ARN by calling the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action. The ARN value must have the form
#' `arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab`.
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_policy
acmpca_delete_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_policy_input(ResourceArn = ResourceArn)
  output <- .acmpca$delete_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_policy <- acmpca_delete_policy

#' Lists information about your private certificate authority (CA) or one
#' that has been shared with you
#'
#' @description
#' Lists information about your private certificate authority (CA) or one that has been shared with you. You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_describe_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_describe_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority
acmpca_describe_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "DescribeCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$describe_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority <- acmpca_describe_certificate_authority

#' Lists information about a specific audit report created by calling the
#' CreateCertificateAuthorityAuditReport action
#'
#' @description
#' Lists information about a specific audit report created by calling the [`create_certificate_authority_audit_report`][acmpca_create_certificate_authority_audit_report] action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the [`issue_certificate`][acmpca_issue_certificate] action or the [`revoke_certificate`][acmpca_revoke_certificate] action.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_describe_certificate_authority_audit_report/](https://www.paws-r-sdk.com/docs/acmpca_describe_certificate_authority_audit_report/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the private CA. This must be of the
#' form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param AuditReportId &#91;required&#93; The report ID returned by calling the
#' [`create_certificate_authority_audit_report`][acmpca_create_certificate_authority_audit_report]
#' action.
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority_audit_report
acmpca_describe_certificate_authority_audit_report <- function(CertificateAuthorityArn, AuditReportId) {
  op <- new_operation(
    name = "DescribeCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, AuditReportId = AuditReportId)
  output <- .acmpca$describe_certificate_authority_audit_report_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority_audit_report <- acmpca_describe_certificate_authority_audit_report

#' Retrieves a certificate from your private CA or one that has been shared
#' with you
#'
#' @description
#' Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the [`issue_certificate`][acmpca_issue_certificate] action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the **GetCertificate** action. You can retrieve the certificate if it is in the **ISSUED** state. You can call the [`create_certificate_authority_audit_report`][acmpca_create_certificate_authority_audit_report] action to create a report that contains information about all of the certificates issued and revoked by your private CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_get_certificate/](https://www.paws-r-sdk.com/docs/acmpca_get_certificate/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#' @param CertificateArn &#91;required&#93; The ARN of the issued certificate. The ARN contains the certificate
#' serial number and must be in the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245 `
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate
acmpca_get_certificate <- function(CertificateAuthorityArn, CertificateArn) {
  op <- new_operation(
    name = "GetCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateArn = CertificateArn)
  output <- .acmpca$get_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate <- acmpca_get_certificate

#' Retrieves the certificate and certificate chain for your private
#' certificate authority (CA) or one that has been shared with you
#'
#' @description
#' Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_get_certificate_authority_certificate/](https://www.paws-r-sdk.com/docs/acmpca_get_certificate_authority_certificate/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of your private CA. This is of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `.
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_certificate
acmpca_get_certificate_authority_certificate <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_certificate <- acmpca_get_certificate_authority_certificate

#' Retrieves the certificate signing request (CSR) for your private
#' certificate authority (CA)
#'
#' @description
#' Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the [`create_certificate_authority`][acmpca_create_certificate_authority] action. Sign the CSR with your Amazon Web Services Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into Amazon Web Services Private CA by calling the [`import_certificate_authority_certificate`][acmpca_import_certificate_authority_certificate] action. The CSR is returned as a base64 PEM-encoded string.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_get_certificate_authority_csr/](https://www.paws-r-sdk.com/docs/acmpca_get_certificate_authority_csr/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [`create_certificate_authority`][acmpca_create_certificate_authority]
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_csr
acmpca_get_certificate_authority_csr <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCsr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_csr_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_csr_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_csr <- acmpca_get_certificate_authority_csr

#' Retrieves the resource-based policy attached to a private CA
#'
#' @description
#' Retrieves the resource-based policy attached to a private CA. If either the private CA resource or the policy cannot be found, this action returns a `ResourceNotFoundException`.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_get_policy/](https://www.paws-r-sdk.com/docs/acmpca_get_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that will have its
#' policy retrieved. You can find the CA's ARN by calling the
#' ListCertificateAuthorities action.
#'
#' @keywords internal
#'
#' @rdname acmpca_get_policy
acmpca_get_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_policy_input(ResourceArn = ResourceArn)
  output <- .acmpca$get_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_policy <- acmpca_get_policy

#' Imports a signed private CA certificate into Amazon Web Services Private
#' CA
#'
#' @description
#' Imports a signed private CA certificate into Amazon Web Services Private CA. This action is used when you are using a chain of trust whose root is located outside Amazon Web Services Private CA. Before you can call this action, the following preparations must in place:
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_import_certificate_authority_certificate/](https://www.paws-r-sdk.com/docs/acmpca_import_certificate_authority_certificate/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param Certificate &#91;required&#93; The PEM-encoded certificate for a private CA. This may be a self-signed
#' certificate in the case of a root CA, or it may be signed by another CA
#' that you control.
#' @param CertificateChain A PEM-encoded file that contains all of your certificates, other than
#' the certificate you're importing, chaining up to your root CA. Your
#' Amazon Web Services Private CA-hosted or on-premises root certificate is
#' the last in the chain, and each certificate in the chain signs the one
#' preceding.
#' 
#' This parameter must be supplied when you import a subordinate CA. When
#' you import a root CA, there is no chain.
#'
#' @keywords internal
#'
#' @rdname acmpca_import_certificate_authority_certificate
acmpca_import_certificate_authority_certificate <- function(CertificateAuthorityArn, Certificate, CertificateChain = NULL) {
  op <- new_operation(
    name = "ImportCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$import_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, Certificate = Certificate, CertificateChain = CertificateChain)
  output <- .acmpca$import_certificate_authority_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$import_certificate_authority_certificate <- acmpca_import_certificate_authority_certificate

#' Uses your private certificate authority (CA), or one that has been
#' shared with you, to issue a client certificate
#'
#' @description
#' Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the [`get_certificate`][acmpca_get_certificate] action and specifying the ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_issue_certificate/](https://www.paws-r-sdk.com/docs/acmpca_issue_certificate/) for full documentation.
#'
#' @param ApiPassthrough Specifies X.509 certificate information to be included in the issued
#' certificate. An `APIPassthrough` or `APICSRPassthrough` template variant
#' must be selected, or else this parameter is ignored. For more
#' information about using these templates, see [Understanding Certificate
#' Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
#' 
#' If conflicting or duplicate certificate information is supplied during
#' certificate issuance, Amazon Web Services Private CA applies [order of
#' operation
#' rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations)
#' to determine what information is used.
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param Csr &#91;required&#93; The certificate signing request (CSR) for the certificate you want to
#' issue. As an example, you can use the following OpenSSL command to
#' create the CSR and a 2048 bit RSA private key.
#' 
#' `openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' 
#' If you have a configuration file, you can then use the following OpenSSL
#' command. The `usr_cert` block in the configuration file contains your
#' X509 version 3 extensions.
#' 
#' `openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' 
#' Note: A CSR must provide either a *subject name* or a *subject
#' alternative name* or the request will be rejected.
#' @param SigningAlgorithm &#91;required&#93; The name of the algorithm that will be used to sign the certificate to
#' be issued.
#' 
#' This parameter should not be confused with the `SigningAlgorithm`
#' parameter used to sign a CSR in the
#' [`create_certificate_authority`][acmpca_create_certificate_authority]
#' action.
#' 
#' The specified signing algorithm family (RSA or ECDSA) must match the
#' algorithm family of the CA's secret key.
#' @param TemplateArn Specifies a custom configuration template to use when issuing a
#' certificate. If this parameter is not provided, Amazon Web Services
#' Private CA defaults to the `EndEntityCertificate/V1` template. For CA
#' certificates, you should choose the shortest path length that meets your
#' needs. The path length is indicated by the PathLen*N* portion of the
#' ARN, where *N* is the [CA
#' depth](https://docs.aws.amazon.com/privateca/latest/userguide/PcaTerms.html#terms-cadepth).
#' 
#' Note: The CA depth configured on a subordinate CA certificate must not
#' exceed the limit set by its parents in the CA hierarchy.
#' 
#' For a list of `TemplateArn` values supported by Amazon Web Services
#' Private CA, see [Understanding Certificate
#' Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
#' @param Validity &#91;required&#93; Information describing the end of the validity period of the
#' certificate. This parameter sets the “Not After” date for the
#' certificate.
#' 
#' Certificate validity is the period of time during which a certificate is
#' valid. Validity can be expressed as an explicit date and time when the
#' certificate expires, or as a span of time after issuance, stated in
#' days, months, or years. For more information, see
#' [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5)
#' in RFC 5280.
#' 
#' This value is unaffected when `ValidityNotBefore` is also specified. For
#' example, if `Validity` is set to 20 days in the future, the certificate
#' will expire 20 days from issuance time regardless of the
#' `ValidityNotBefore` value.
#' 
#' The end of the validity period configured on a certificate must not
#' exceed the limit set on its parents in the CA hierarchy.
#' @param ValidityNotBefore Information describing the start of the validity period of the
#' certificate. This parameter sets the “Not Before" date for the
#' certificate.
#' 
#' By default, when issuing a certificate, Amazon Web Services Private CA
#' sets the "Not Before" date to the issuance time minus 60 minutes. This
#' compensates for clock inconsistencies across computer systems. The
#' `ValidityNotBefore` parameter can be used to customize the “Not Before”
#' value.
#' 
#' Unlike the `Validity` parameter, the `ValidityNotBefore` parameter is
#' optional.
#' 
#' The `ValidityNotBefore` value is expressed as an explicit date and time,
#' using the `Validity` type value `ABSOLUTE`. For more information, see
#' [Validity](https://docs.aws.amazon.com/privateca/latest/APIReference/API_Validity.html)
#' in this API reference and
#' [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5)
#' in RFC 5280.
#' @param IdempotencyToken Alphanumeric string that can be used to distinguish between calls to the
#' **IssueCertificate** action. Idempotency tokens for **IssueCertificate**
#' time out after five minutes. Therefore, if you call **IssueCertificate**
#' multiple times with the same idempotency token within five minutes,
#' Amazon Web Services Private CA recognizes that you are requesting only
#' one certificate and will issue only one. If you change the idempotency
#' token for each call, Amazon Web Services Private CA recognizes that you
#' are requesting multiple certificates.
#'
#' @keywords internal
#'
#' @rdname acmpca_issue_certificate
acmpca_issue_certificate <- function(ApiPassthrough = NULL, CertificateAuthorityArn, Csr, SigningAlgorithm, TemplateArn = NULL, Validity, ValidityNotBefore = NULL, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "IssueCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$issue_certificate_input(ApiPassthrough = ApiPassthrough, CertificateAuthorityArn = CertificateAuthorityArn, Csr = Csr, SigningAlgorithm = SigningAlgorithm, TemplateArn = TemplateArn, Validity = Validity, ValidityNotBefore = ValidityNotBefore, IdempotencyToken = IdempotencyToken)
  output <- .acmpca$issue_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$issue_certificate <- acmpca_issue_certificate

#' Lists the private certificate authorities that you created by using the
#' CreateCertificateAuthority action
#'
#' @description
#' Lists the private certificate authorities that you created by using the [`create_certificate_authority`][acmpca_create_certificate_authority] action.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_list_certificate_authorities/](https://www.paws-r-sdk.com/docs/acmpca_list_certificate_authorities/) for full documentation.
#'
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' 
#' Although the maximum value is 1000, the action only returns a maximum of
#' 100 items.
#' @param ResourceOwner Use this parameter to filter the returned set of certificate authorities
#' based on their owner. The default is SELF.
#'
#' @keywords internal
#'
#' @rdname acmpca_list_certificate_authorities
acmpca_list_certificate_authorities <- function(NextToken = NULL, MaxResults = NULL, ResourceOwner = NULL) {
  op <- new_operation(
    name = "ListCertificateAuthorities",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CertificateAuthorities")
  )
  input <- .acmpca$list_certificate_authorities_input(NextToken = NextToken, MaxResults = MaxResults, ResourceOwner = ResourceOwner)
  output <- .acmpca$list_certificate_authorities_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_certificate_authorities <- acmpca_list_certificate_authorities

#' List all permissions on a private CA, if any, granted to the Certificate
#' Manager (ACM) service principal (acm
#'
#' @description
#' List all permissions on a private CA, if any, granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_list_permissions/](https://www.paws-r-sdk.com/docs/acmpca_list_permissions/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA to inspect. You can
#' find the ARN by calling the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action. This must be of the form:
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
#' You can get a private CA's ARN by running the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action.
#' @param NextToken When paginating results, use this parameter in a subsequent request
#' after you receive a response with truncated results. Set it to the value
#' of **NextToken** from the response you just received.
#' @param MaxResults When paginating results, use this parameter to specify the maximum
#' number of items to return in the response. If additional items exist
#' beyond the number you specify, the **NextToken** element is sent in the
#' response. Use this **NextToken** value in a subsequent request to
#' retrieve additional items.
#'
#' @keywords internal
#'
#' @rdname acmpca_list_permissions
acmpca_list_permissions <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Permissions")
  )
  input <- .acmpca$list_permissions_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_permissions_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_permissions <- acmpca_list_permissions

#' Lists the tags, if any, that are associated with your private CA or one
#' that has been shared with you
#'
#' @description
#' Lists the tags, if any, that are associated with your private CA or one that has been shared with you. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the [`tag_certificate_authority`][acmpca_tag_certificate_authority] action to add one or more tags to your CA. Call the [`untag_certificate_authority`][acmpca_untag_certificate_authority] action to remove tags.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_list_tags/](https://www.paws-r-sdk.com/docs/acmpca_list_tags/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [`create_certificate_authority`][acmpca_create_certificate_authority]
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' **NextToken** from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response. If additional items exist beyond the
#' number you specify, the **NextToken** element is sent in the response.
#' Use this **NextToken** value in a subsequent request to retrieve
#' additional items.
#'
#' @keywords internal
#'
#' @rdname acmpca_list_tags
acmpca_list_tags <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Tags")
  )
  input <- .acmpca$list_tags_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_tags_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_tags <- acmpca_list_tags

#' Attaches a resource-based policy to a private CA
#'
#' @description
#' Attaches a resource-based policy to a private CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_put_policy/](https://www.paws-r-sdk.com/docs/acmpca_put_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA to associate with the
#' policy. The ARN of the CA can be found by calling the
#' [`list_certificate_authorities`][acmpca_list_certificate_authorities]
#' action.
#' @param Policy &#91;required&#93; The path and file name of a JSON-formatted IAM policy to attach to the
#' specified private CA resource. If this policy does not contain all
#' required statements or if it includes any statement that is not allowed,
#' the [`put_policy`][acmpca_put_policy] action returns an
#' `InvalidPolicyException`. For information about IAM policy and statement
#' structure, see [Overview of JSON
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
#'
#' @keywords internal
#'
#' @rdname acmpca_put_policy
acmpca_put_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$put_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .acmpca$put_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$put_policy <- acmpca_put_policy

#' Restores a certificate authority (CA) that is in the DELETED state
#'
#' @description
#' Restores a certificate authority (CA) that is in the `DELETED` state. You can restore a CA during the period that you defined in the **PermanentDeletionTimeInDays** parameter of the [`delete_certificate_authority`][acmpca_delete_certificate_authority] action. Currently, you can specify 7 to 30 days. If you did not specify a **PermanentDeletionTimeInDays** value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the `DELETED` state by calling the [`describe_certificate_authority`][acmpca_describe_certificate_authority] or [`list_certificate_authorities`][acmpca_list_certificate_authorities] actions. The status of a restored CA is set to its pre-deletion status when the **RestoreCertificateAuthority** action returns. To change its status to `ACTIVE`, call the [`update_certificate_authority`][acmpca_update_certificate_authority] action. If the private CA was in the `PENDING_CERTIFICATE` state at deletion, you must use the [`import_certificate_authority_certificate`][acmpca_import_certificate_authority_certificate] action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_restore_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_restore_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [`create_certificate_authority`][acmpca_create_certificate_authority]
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#'
#' @keywords internal
#'
#' @rdname acmpca_restore_certificate_authority
acmpca_restore_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "RestoreCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$restore_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$restore_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$restore_certificate_authority <- acmpca_restore_certificate_authority

#' Revokes a certificate that was issued inside Amazon Web Services Private
#' CA
#'
#' @description
#' Revokes a certificate that was issued inside Amazon Web Services Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. Amazon Web Services Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, Amazon Web Services Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics `CRLGenerated` and `MisconfiguredCRLBucket`. For more information, see [Supported CloudWatch Metrics](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCloudWatch.html).
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_revoke_certificate/](https://www.paws-r-sdk.com/docs/acmpca_revoke_certificate/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param CertificateSerial &#91;required&#93; Serial number of the certificate to be revoked. This must be in
#' hexadecimal format. You can retrieve the serial number by calling
#' [`get_certificate`][acmpca_get_certificate] with the Amazon Resource
#' Name (ARN) of the certificate you want and the ARN of your private CA.
#' The **GetCertificate** action retrieves the certificate in the PEM
#' format. You can use the following OpenSSL command to list the
#' certificate in text format and copy the hexadecimal serial number.
#' 
#' `openssl x509 -in file_path -text -noout`
#' 
#' You can also copy the serial number from the console or use the
#' [DescribeCertificate](https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
#' action in the *Certificate Manager API Reference*.
#' @param RevocationReason &#91;required&#93; Specifies why you revoked the certificate.
#'
#' @keywords internal
#'
#' @rdname acmpca_revoke_certificate
acmpca_revoke_certificate <- function(CertificateAuthorityArn, CertificateSerial, RevocationReason) {
  op <- new_operation(
    name = "RevokeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$revoke_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateSerial = CertificateSerial, RevocationReason = RevocationReason)
  output <- .acmpca$revoke_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$revoke_certificate <- acmpca_revoke_certificate

#' Adds one or more tags to your private CA
#'
#' @description
#' Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the [`untag_certificate_authority`][acmpca_untag_certificate_authority] action. Call the [`list_tags`][acmpca_list_tags] action to see what tags are associated with your CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_tag_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_tag_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param Tags &#91;required&#93; List of tags to be associated with the CA.
#'
#' @keywords internal
#'
#' @rdname acmpca_tag_certificate_authority
acmpca_tag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "TagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$tag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$tag_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$tag_certificate_authority <- acmpca_tag_certificate_authority

#' Remove one or more tags from your private CA
#'
#' @description
#' Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the [`tag_certificate_authority`][acmpca_tag_certificate_authority]. Call the [`list_tags`][acmpca_list_tags] action to see what tags are associated with your CA.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_untag_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_untag_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [`create_certificate_authority`][acmpca_create_certificate_authority].
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param Tags &#91;required&#93; List of tags to be removed from the CA.
#'
#' @keywords internal
#'
#' @rdname acmpca_untag_certificate_authority
acmpca_untag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "UntagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$untag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$untag_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$untag_certificate_authority <- acmpca_untag_certificate_authority

#' Updates the status or configuration of a private certificate authority
#' (CA)
#'
#' @description
#' Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the `ACTIVE` or `DISABLED` state before you can update it. You can disable a private CA that is in the `ACTIVE` state or make a CA that is in the `DISABLED` state active again.
#'
#' See [https://www.paws-r-sdk.com/docs/acmpca_update_certificate_authority/](https://www.paws-r-sdk.com/docs/acmpca_update_certificate_authority/) for full documentation.
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 `
#' @param RevocationConfiguration Contains information to enable Online Certificate Status Protocol (OCSP)
#' support, to enable a certificate revocation list (CRL), to enable both,
#' or to enable neither. If this parameter is not supplied, existing
#' capibilites remain unchanged. For more information, see the
#' [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html)
#' and
#' [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html)
#' types.
#' 
#' The following requirements apply to revocation configurations.
#' 
#' -   A configuration disabling CRLs or OCSP must contain only the
#'     `Enabled=False` parameter, and will fail if other parameters such as
#'     `CustomCname` or `ExpirationInDays` are included.
#' 
#' -   In a CRL configuration, the `S3BucketName` parameter must conform to
#'     [Amazon S3 bucket naming
#'     rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
#' 
#' -   A configuration containing a custom Canonical Name (CNAME) parameter
#'     for CRLs or OCSP must conform to
#'     [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the
#'     use of special characters in a CNAME.
#' 
#' -   In a CRL or OCSP configuration, the value of a CNAME parameter must
#'     not include a protocol prefix such as "http://" or "https://".
#' @param Status Status of your private CA.
#'
#' @keywords internal
#'
#' @rdname acmpca_update_certificate_authority
acmpca_update_certificate_authority <- function(CertificateAuthorityArn, RevocationConfiguration = NULL, Status = NULL) {
  op <- new_operation(
    name = "UpdateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$update_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, RevocationConfiguration = RevocationConfiguration, Status = Status)
  output <- .acmpca$update_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$update_certificate_authority <- acmpca_update_certificate_authority
