% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_set_default_permission_version}
\alias{ram_set_default_permission_version}
\title{Designates the specified version number as the default version for the
specified customer managed permission}
\usage{
ram_set_default_permission_version(
  permissionArn,
  permissionVersion,
  clientToken = NULL
)
}
\arguments{
\item{permissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the customer managed permission whose default version you want to
change.}

\item{permissionVersion}{[required] Specifies the version number that you want to designate as the default
for customer managed permission. To see a list of all available version
numbers, use \code{\link[=ram_list_permission_versions]{list_permission_versions}}.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
Designates the specified version number as the default version for the specified customer managed permission. New resource shares automatically use this new default permission. Existing resource shares continue to use their original permission version, but you can use \code{\link[=ram_replace_permission_associations]{replace_permission_associations}} to update them.

See \url{https://www.paws-r-sdk.com/docs/ram_set_default_permission_version/} for full documentation.
}
\keyword{internal}
