# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Security Lake
#'
#' @description
#' Amazon Security Lake is a fully managed security data lake service. You
#' can use Security Lake to automatically centralize security data from
#' cloud, on-premises, and custom sources into a data lake that's stored in
#' your Amazon Web Services account. Amazon Web Services Organizations is
#' an account management service that lets you consolidate multiple Amazon
#' Web Services accounts into an organization that you create and centrally
#' manage. With Organizations, you can create member accounts and invite
#' existing accounts to join your organization. Security Lake helps you
#' analyze security data for a more complete understanding of your security
#' posture across the entire organization. It can also help you improve the
#' protection of your workloads, applications, and data.
#' 
#' The data lake is backed by Amazon Simple Storage Service (Amazon S3)
#' buckets, and you retain ownership over your data.
#' 
#' Amazon Security Lake integrates with CloudTrail, a service that provides
#' a record of actions taken by a user, role, or an Amazon Web Services
#' service. In Security Lake, CloudTrail captures API calls for Security
#' Lake as events. The calls captured include calls from the Security Lake
#' console and code calls to the Security Lake API operations. If you
#' create a trail, you can enable continuous delivery of CloudTrail events
#' to an Amazon S3 bucket, including events for Security Lake. If you don't
#' configure a trail, you can still view the most recent events in the
#' CloudTrail console in Event history. Using the information collected by
#' CloudTrail you can determine the request that was made to Security Lake,
#' the IP address from which the request was made, who made the request,
#' when it was made, and additional details. To learn more about Security
#' Lake information in CloudTrail, see the [Amazon Security Lake User
#' Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/securitylake-cloudtrail.html).
#' 
#' Security Lake automates the collection of security-related log and event
#' data from integrated Amazon Web Services and third-party services. It
#' also helps you manage the lifecycle of data with customizable retention
#' and replication settings. Security Lake converts ingested data into
#' Apache Parquet format and a standard open-source schema called the Open
#' Cybersecurity Schema Framework (OCSF).
#' 
#' Other Amazon Web Services and third-party services can subscribe to the
#' data that's stored in Security Lake for incident response and security
#' data analytics.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- securitylake(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- securitylake()
#' svc$create_aws_log_source(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=securitylake_create_aws_log_source]{create_aws_log_source} \tab Adds a natively supported Amazon Web Service as an Amazon Security Lake source\cr
#'  \link[=securitylake_create_custom_log_source]{create_custom_log_source} \tab Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source\cr
#'  \link[=securitylake_create_data_lake]{create_data_lake} \tab Initializes an Amazon Security Lake instance with the provided (or default) configuration\cr
#'  \link[=securitylake_create_data_lake_exception_subscription]{create_data_lake_exception_subscription} \tab Creates the specified notification subscription in Amazon Security Lake for the organization you specify\cr
#'  \link[=securitylake_create_data_lake_organization_configuration]{create_data_lake_organization_configuration} \tab Automatically enables Amazon Security Lake for new member accounts in your organization\cr
#'  \link[=securitylake_create_subscriber]{create_subscriber} \tab Creates a subscription permission for accounts that are already enabled in Amazon Security Lake\cr
#'  \link[=securitylake_create_subscriber_notification]{create_subscriber_notification} \tab Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake\cr
#'  \link[=securitylake_delete_aws_log_source]{delete_aws_log_source} \tab Removes a natively supported Amazon Web Service as an Amazon Security Lake source\cr
#'  \link[=securitylake_delete_custom_log_source]{delete_custom_log_source} \tab Removes a custom log source from Amazon Security Lake, to stop sending data from the custom source to Security Lake\cr
#'  \link[=securitylake_delete_data_lake]{delete_data_lake} \tab When you disable Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services Regions and it stops collecting data from your sources\cr
#'  \link[=securitylake_delete_data_lake_exception_subscription]{delete_data_lake_exception_subscription} \tab Deletes the specified notification subscription in Amazon Security Lake for the organization you specify\cr
#'  \link[=securitylake_delete_data_lake_organization_configuration]{delete_data_lake_organization_configuration} \tab Turns off automatic enablement of Amazon Security Lake for member accounts that are added to an organization in Organizations\cr
#'  \link[=securitylake_delete_subscriber]{delete_subscriber} \tab Deletes the subscription permission and all notification settings for accounts that are already enabled in Amazon Security Lake\cr
#'  \link[=securitylake_delete_subscriber_notification]{delete_subscriber_notification} \tab Deletes the specified notification subscription in Amazon Security Lake for the organization you specify\cr
#'  \link[=securitylake_deregister_data_lake_delegated_administrator]{deregister_data_lake_delegated_administrator} \tab Deletes the Amazon Security Lake delegated administrator account for the organization\cr
#'  \link[=securitylake_get_data_lake_exception_subscription]{get_data_lake_exception_subscription} \tab Retrieves the details of exception notifications for the account in Amazon Security Lake\cr
#'  \link[=securitylake_get_data_lake_organization_configuration]{get_data_lake_organization_configuration} \tab Retrieves the configuration that will be automatically set up for accounts added to the organization after the organization has onboarded to Amazon Security Lake\cr
#'  \link[=securitylake_get_data_lake_sources]{get_data_lake_sources} \tab Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from\cr
#'  \link[=securitylake_get_subscriber]{get_subscriber} \tab Retrieves the subscription information for the specified subscription ID\cr
#'  \link[=securitylake_list_data_lake_exceptions]{list_data_lake_exceptions} \tab Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them\cr
#'  \link[=securitylake_list_data_lakes]{list_data_lakes} \tab Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services Regions\cr
#'  \link[=securitylake_list_log_sources]{list_log_sources} \tab Retrieves the log sources in the current Amazon Web Services Region\cr
#'  \link[=securitylake_list_subscribers]{list_subscribers} \tab List all subscribers for the specific Amazon Security Lake account ID\cr
#'  \link[=securitylake_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves the tags (keys and values) that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region\cr
#'  \link[=securitylake_register_data_lake_delegated_administrator]{register_data_lake_delegated_administrator} \tab Designates the Amazon Security Lake delegated administrator account for the organization\cr
#'  \link[=securitylake_tag_resource]{tag_resource} \tab Adds or updates one or more tags that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region\cr
#'  \link[=securitylake_untag_resource]{untag_resource} \tab Removes one or more tags (keys and values) from an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region\cr
#'  \link[=securitylake_update_data_lake]{update_data_lake} \tab Specifies where to store your security data and for how long\cr
#'  \link[=securitylake_update_data_lake_exception_subscription]{update_data_lake_exception_subscription} \tab Updates the specified notification subscription in Amazon Security Lake for the organization you specify\cr
#'  \link[=securitylake_update_subscriber]{update_subscriber} \tab Updates an existing subscription for the given Amazon Security Lake account ID\cr
#'  \link[=securitylake_update_subscriber_notification]{update_subscriber_notification} \tab Updates an existing notification method for the subscription (SQS or HTTPs endpoint) or switches the notification subscription endpoint for a subscriber
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname securitylake
#' @export
securitylake <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .securitylake$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.securitylake <- list()

.securitylake$operations <- list()

.securitylake$metadata <- list(
  service_name = "securitylake",
  endpoints = list("*" = list(endpoint = "securitylake.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "securitylake.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "securitylake.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "securitylake.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "SecurityLake",
  api_version = "2018-05-10",
  signing_name = "securitylake",
  json_version = "1.1",
  target_prefix = ""
)

.securitylake$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.securitylake$metadata, handlers, config)
}
