% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_check_capacity}
\alias{wafv2_check_capacity}
\title{Returns the web ACL capacity unit (WCU) requirements for a specified
scope and set of rules}
\usage{
wafv2_check_capacity(Scope, Rules)
}
\arguments{
\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{Rules}{[required] An array of Rule that you're configuring to use in a rule group or web
ACL.}
}
\description{
Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.

See \url{https://www.paws-r-sdk.com/docs/wafv2_check_capacity/} for full documentation.
}
\keyword{internal}
