% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_create_assessment_template}
\alias{inspector_create_assessment_template}
\title{Creates an assessment template for the assessment target that is
specified by the ARN of the assessment target}
\usage{
inspector_create_assessment_template(assessmentTargetArn,
  assessmentTemplateName, durationInSeconds, rulesPackageArns,
  userAttributesForFindings)
}
\arguments{
\item{assessmentTargetArn}{[required] The ARN that specifies the assessment target for which you want to
create the assessment template.}

\item{assessmentTemplateName}{[required] The user-defined name that identifies the assessment template that you
want to create. You can create several assessment templates for an
assessment target. The names of the assessment templates that correspond
to a particular assessment target must be unique.}

\item{durationInSeconds}{[required] The duration of the assessment run in seconds.}

\item{rulesPackageArns}{[required] The ARNs that specify the rules packages that you want to attach to the
assessment template.}

\item{userAttributesForFindings}{The user-defined attributes that are assigned to every finding that is
generated by the assessment run that uses this assessment template. An
attribute is a key and value pair (an Attribute object). Within an
assessment template, each key must be unique.}
}
\description{
Creates an assessment template for the assessment target that is
specified by the ARN of the assessment target. If the \href{https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html}{service-linked role}
isn't already registered, this action also creates and registers a
service-linked role to grant Amazon Inspector access to AWS Services
needed to perform security assessments.
}
\section{Request syntax}{
\preformatted{svc$create_assessment_template(
  assessmentTargetArn = "string",
  assessmentTemplateName = "string",
  durationInSeconds = 123,
  rulesPackageArns = list(
    "string"
  ),
  userAttributesForFindings = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Creates an assessment template for the assessment target that is
# specified by the ARN of the assessment target.
svc$create_assessment_template(
  assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX",
  assessmentTemplateName = "ExampleAssessmentTemplate",
  durationInSeconds = 180L,
  rulesPackageArns = list(
    "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-11B9DBXp"
  ),
  userAttributesForFindings = list(
    list(
      key = "Example",
      value = "example"
    )
  )
)
}

}
\keyword{internal}
