% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_incoming_typed_links}
\alias{clouddirectory_list_incoming_typed_links}
\title{Returns a paginated list of all the incoming TypedLinkSpecifier
information for an object}
\usage{
clouddirectory_list_incoming_typed_links(DirectoryArn, ObjectReference,
  FilterAttributeRanges, FilterTypedLink, NextToken, MaxResults,
  ConsistencyLevel)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) of the directory where you want to list
the typed links.}

\item{ObjectReference}{[required] Reference that identifies the object whose attributes will be listed.}

\item{FilterAttributeRanges}{Provides range filters for multiple attributes. When providing ranges to
typed link selection, any inexact ranges must be specified at the end.
Any attributes that do not have a range specified are presumed to match
the entire range.}

\item{FilterTypedLink}{Filters are interpreted in the order of the attributes on the typed link
facet, not the order in which they are supplied to any API calls.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of results to retrieve.}

\item{ConsistencyLevel}{The consistency level to execute the request at.}
}
\description{
Returns a paginated list of all the incoming TypedLinkSpecifier
information for an object. It also supports filtering by typed link
facet and identity attributes. For more information, see \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.
}
\section{Request syntax}{
\preformatted{svc$list_incoming_typed_links(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  FilterAttributeRanges = list(
    list(
      AttributeName = "string",
      Range = list(
        StartMode = "FIRST"|"LAST"|"LAST_BEFORE_MISSING_VALUES"|"INCLUSIVE"|"EXCLUSIVE",
        StartValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        ),
        EndMode = "FIRST"|"LAST"|"LAST_BEFORE_MISSING_VALUES"|"INCLUSIVE"|"EXCLUSIVE",
        EndValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  FilterTypedLink = list(
    SchemaArn = "string",
    TypedLinkName = "string"
  ),
  NextToken = "string",
  MaxResults = 123,
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL"
)
}
}

\keyword{internal}
